/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.fastnate.generator.RelativeDate;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.PlainStatement;

public abstract class GeneratorDialect {
    @Deprecated
    public static final Date NOW = new Date();
    private final char[] letter = "0123456789ABCDEF".toCharArray();

    private static void finishPart(StringBuilder result, String value, int start, int end, boolean isOpen, boolean close, String concatOperator) {
        if (start < end) {
            if (!isOpen) {
                if (start > 0) {
                    result.append(concatOperator);
                }
                result.append('\'');
            }
            result.append(value, start, end);
            if (close) {
                result.append('\'');
            }
        } else if (isOpen && close) {
            result.append('\'');
        } else if (!isOpen && !close) {
            if (start > 0) {
                result.append(concatOperator);
            }
            result.append('\'');
        }
    }

    protected void addQuotedCharacter(StringBuilder result, char c) {
        result.append("CHR(").append((byte)c).append(')');
    }

    public List<? extends EntityStatement> adjustNextIdentityValue(String tableName, String columnName, long nextValue) {
        return Collections.emptyList();
    }

    public List<? extends EntityStatement> adjustNextSequenceValue(String sequenceName, long currentSequenceValue, long nextSequenceValue, int incrementSize) {
        if (this.isEmulatingSequences()) {
            return Collections.singletonList(new PlainStatement("UPDATE " + sequenceName + " SET next_val = " + nextSequenceValue));
        }
        return Collections.singletonList(new PlainStatement("ALTER SEQUENCE " + sequenceName + " RESTART WITH " + nextSequenceValue));
    }

    public String buildCurrentSequenceValue(String sequence, int incrementSize) {
        if (this.isEmulatingSequences()) {
            return "(SELECT max(next_val) - " + incrementSize + " FROM " + sequence + ")";
        }
        return "currval('" + sequence + "')";
    }

    public String buildNextSequenceValue(String sequence, int incrementSize) {
        if (this.isEmulatingSequences()) {
            return "UPDATE " + sequence + " SET next_val = next_val + " + incrementSize;
        }
        return "nextval('" + sequence + "')";
    }

    public String convertBooleanValue(boolean value) {
        return value ? "1" : "0";
    }

    protected String convertTemporalValue(Date sqlDate) {
        return '\'' + sqlDate.toString() + '\'';
    }

    public String convertTemporalValue(Date value, TemporalType type) {
        Date date;
        if (RelativeDate.NOW.equals(value)) {
            return "CURRENT_TIMESTAMP";
        }
        if (RelativeDate.TODAY.equals(value)) {
            return "CURRENT_DATE";
        }
        if (value instanceof RelativeDate) {
            RelativeDate relativeDate = (RelativeDate)value;
            long difference = relativeDate.getDifference();
            RelativeDate.Precision precision = relativeDate.getPrecision();
            return this.createAddDateExpression(this.convertTemporalValue(((RelativeDate)value).getReferenceDate(), type), difference / precision.getMillis(), precision.getUnit());
        }
        switch (type) {
            case DATE: {
                date = value instanceof java.sql.Date ? (java.sql.Date)value : new java.sql.Date(value.getTime());
                break;
            }
            case TIME: {
                date = value instanceof Time ? (Time)value : new Time(value.getTime());
                break;
            }
            default: {
                date = value instanceof Timestamp ? (Timestamp)value : new Timestamp(value.getTime());
            }
        }
        return this.convertTemporalValue(date);
    }

    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return "DATEADD(" + unit + ", " + value + ", " + referenceDate + ')';
    }

    public String createBlobExpression(byte[] blob) {
        throw new IllegalArgumentException("Blobs are not supported by " + this.getClass().getSimpleName());
    }

    protected String createHexBlobExpression(String prefix, byte[] blob, String suffix) {
        int start = prefix.length();
        int suffixStart = start + blob.length * 2;
        char[] result = new char[suffixStart + suffix.length()];
        prefix.getChars(0, start, result, 0);
        for (int i = 0; i < blob.length; ++i) {
            int v = blob[i] & 0xFF;
            result[i * 2 + start] = this.letter[v >>> 4];
            result[i * 2 + start + 1] = this.letter[v & 0xF];
        }
        suffix.getChars(0, suffix.length(), result, suffixStart);
        return new String(result);
    }

    public String createSql(EntityStatement stmt) {
        return stmt.toSql();
    }

    public GenerationType getAutoGenerationType() {
        return this.isSequenceSupported() ? GenerationType.SEQUENCE : (this.isIdentitySupported() ? GenerationType.IDENTITY : GenerationType.TABLE);
    }

    public String getConcatOperator() {
        return " || ";
    }

    public String getOptionalTable() {
        return "";
    }

    public boolean isEmptyStringEqualToNull() {
        return false;
    }

    protected boolean isEmulatingSequences() {
        return false;
    }

    public boolean isIdentitySupported() {
        return true;
    }

    public boolean isNextSequenceValueInInsertSupported() {
        return !this.isEmulatingSequences();
    }

    public boolean isSequenceInWhereSupported() {
        return this.isSequenceSupported();
    }

    public boolean isSequenceSupported() {
        return true;
    }

    public boolean isSettingIdentityAllowed() {
        return true;
    }

    public String quoteString(String value) {
        if (value.length() == 0) {
            return "''";
        }
        StringBuilder result = new StringBuilder(value.length() + 2);
        int start = 0;
        boolean isOpen = false;
        String concatOperator = this.getConcatOperator();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < ' ' && c != '\t') {
                if (i > 0) {
                    GeneratorDialect.finishPart(result, value, start, i, isOpen, true, concatOperator);
                    isOpen = false;
                    result.append(concatOperator);
                }
                this.addQuotedCharacter(result, c);
            } else {
                if (c != '\'') continue;
                GeneratorDialect.finishPart(result, value, start, i, isOpen, false, concatOperator);
                isOpen = true;
                result.append("''");
            }
            start = i + 1;
        }
        GeneratorDialect.finishPart(result, value, start, value.length(), isOpen, true, concatOperator);
        return result.toString();
    }

    public char[] getLetter() {
        return this.letter;
    }
}

