/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;

public class MySqlDialect
extends GeneratorDialect {
    private static final char MAX_ESCAPE = '\\';
    private static final String[] ESCAPES = new String[93];
    private static final Joiner JOINER = Joiner.on((String)", ");

    @Override
    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return "DATE_ADD(" + referenceDate + ", INTERVAL " + value + ' ' + unit + ')';
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        return this.createHexBlobExpression("x'", blob, "'");
    }

    @Override
    public String createSql(EntityStatement stmt) {
        if (!(stmt instanceof InsertStatement)) {
            return stmt.toString();
        }
        InsertStatement statement = (InsertStatement)stmt;
        Map<String, String> values = statement.getValues();
        if (values.isEmpty()) {
            return "INSERT INTO " + statement.getTable() + " VALUES ();\n";
        }
        Pattern subselectPattern = Pattern.compile("\\(SELECT\\s+(.*)\\s+FROM\\s+" + statement.getTable() + "\\s*\\)", 2);
        if (!subselectPattern.matcher(values.values().toString()).find()) {
            return stmt.toString();
        }
        StringBuilder result = new StringBuilder("INSERT INTO ").append(statement.getTable());
        result.append(" (");
        JOINER.appendTo(result, values.keySet()).append(") SELECT ");
        ArrayList<String> rewrite = new ArrayList<String>();
        for (String value : values.values()) {
            Matcher matcher = subselectPattern.matcher(value);
            if (matcher.matches()) {
                rewrite.add(matcher.group(1));
                continue;
            }
            rewrite.add(value);
        }
        JOINER.appendTo(result, rewrite).append(" FROM ").append(statement.getTable()).append(";\n");
        return result.toString();
    }

    @Override
    public String getOptionalTable() {
        return "FROM DUAL";
    }

    @Override
    protected boolean isEmulatingSequences() {
        return true;
    }

    @Override
    public String quoteString(String value) {
        if (value.length() == 0) {
            return "''";
        }
        StringBuilder result = new StringBuilder(value.length() + 2).append('\'');
        for (int i = 0; i < value.length(); ++i) {
            String escape;
            char c = value.charAt(i);
            if (c <= '\\' && (escape = ESCAPES[c]) != null) {
                result.append(escape);
                continue;
            }
            result.append(c);
        }
        return result.append('\'').toString();
    }

    static {
        MySqlDialect.ESCAPES[0] = "\\0";
        MySqlDialect.ESCAPES[8] = "\\b";
        MySqlDialect.ESCAPES[9] = "\\t";
        MySqlDialect.ESCAPES[10] = "\\n";
        MySqlDialect.ESCAPES[13] = "\\r";
        MySqlDialect.ESCAPES[26] = "\\Z";
        MySqlDialect.ESCAPES[39] = "''";
        MySqlDialect.ESCAPES[92] = "\\\\";
    }
}

