/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.util.Collections;
import java.util.List;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.PlainStatement;

public class PostgresDialect
extends GeneratorDialect {
    @Override
    protected void addQuotedCharacter(StringBuilder result, char c) {
        if (c == '\u0000') {
            throw new IllegalArgumentException("PostgreSQL does not support '\\0' characters");
        }
        super.addQuotedCharacter(result, c);
    }

    @Override
    public List<? extends EntityStatement> adjustNextIdentityValue(String tableName, String columnName, long nextValue) {
        return Collections.singletonList(new PlainStatement("ALTER SEQUENCE " + tableName + "_id_seq RESTART WITH " + nextValue));
    }

    @Override
    public String convertBooleanValue(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return referenceDate + ' ' + (value < 0L ? (char)'-' : '+') + " INTERVAL '" + Math.abs(value) + ' ' + unit + '\'';
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        return this.createHexBlobExpression("decode('", blob, "', 'hex')");
    }
}

