/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.util.Iterator;
import java.util.Map;
import org.fastnate.generator.statements.TableStatement;

public class UpdateStatement
extends TableStatement {
    private final String idColumn;
    private final String idValue;

    public UpdateStatement(String table, String idColumn, String idValue) {
        super(table);
        this.idColumn = idColumn;
        this.idValue = idValue;
    }

    @Override
    public String toSql() {
        StringBuilder result = new StringBuilder("UPDATE ").append(this.getTable()).append(" SET ");
        Iterator<Map.Entry<String, String>> entries = this.getValues().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            result.append(entry.getKey()).append(" = ").append(entry.getValue());
            if (!entries.hasNext()) continue;
            result.append(", ");
        }
        result.append(" WHERE ").append(this.idColumn).append(" = ").append(this.idValue).append(";\n");
        return result.toString();
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public String getIdValue() {
        return this.idValue;
    }
}

