/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.generator;

import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.fcrepo.generator.dublincore.DCGenerator;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.kernel.FedoraResource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/{path: .*}/oai:dc")
public class DublinCoreGenerator
extends AbstractResource {
    @Resource
    List<DCGenerator> dcgenerators;
    @InjectedSession
    protected Session session;

    @GET
    @Produces(value={"text/xml"})
    public Response getObjectAsDublinCore(@PathParam(value="path") List<PathSegment> pathList) throws RepositoryException {
        try {
            String path = DublinCoreGenerator.toPath(pathList);
            FedoraResource obj = this.nodeService.getObject(this.session, path);
            for (DCGenerator indexer : this.dcgenerators) {
                InputStream inputStream = indexer.getStream(obj.getNode());
                if (inputStream == null) continue;
                Response response = Response.ok((Object)inputStream).build();
                return response;
            }
            throw new PathNotFoundException();
        }
        finally {
            this.session.logout();
        }
    }
}

