/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.generator.dublincore;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.fcrepo.generator.dublincore.DCGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WellKnownDatastreamGenerator
implements DCGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WellKnownDatastreamGenerator.class);
    private String wellKnownDsid;

    @Override
    public InputStream getStream(Node node) {
        try {
            return this.getContentInputStream(node);
        }
        catch (RepositoryException e) {
            LOGGER.warn("logged exception", (Throwable)e);
            return null;
        }
    }

    private InputStream getContentInputStream(Node node) throws RepositoryException {
        if (node.hasNode(this.wellKnownDsid)) {
            Node dc = node.getNode(this.wellKnownDsid);
            Binary binary = dc.getNode("jcr:content").getProperty("jcr:data").getBinary();
            return binary.getStream();
        }
        return null;
    }

    public void setWellKnownDsid(String wellKnownDsid) {
        this.wellKnownDsid = wellKnownDsid;
    }
}

