/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.elastic;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.fcrepo.indexer.AsynchIndexer;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.NamedFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticIndexer
extends AsynchIndexer<NamedFields, ActionResponse> {
    @Inject
    private Client client;
    private String searchIndexType;
    private String indexName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticIndexer.class);
    private static final Integer THREAD_POOL_SIZE = 5;
    private ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(THREAD_POOL_SIZE));

    @PostConstruct
    public void initIndex() throws InterruptedException {
        if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.getIndexName()}).execute().actionGet()).isExists()) {
            LOGGER.debug("Creating index {}.", (Object)this.getIndexName());
            this.client.admin().indices().prepareCreate(this.getIndexName()).execute().actionGet();
        }
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().execute().actionGet();
    }

    public Callable<ActionResponse> removeSynch(final String id) {
        return new Callable<ActionResponse>(){

            @Override
            public ActionResponse call() {
                return (ActionResponse)ElasticIndexer.this.client.prepareDelete(ElasticIndexer.this.getIndexName(), ElasticIndexer.this.getSearchIndexType(), id).execute().actionGet();
            }
        };
    }

    public Callable<ActionResponse> updateSynch(final String id, NamedFields content) {
        return new Callable<ActionResponse>(){

            @Override
            public ActionResponse call() {
                return (ActionResponse)ElasticIndexer.this.client.prepareIndex(ElasticIndexer.this.indexName, ElasticIndexer.this.searchIndexType, id).execute().actionGet();
            }
        };
    }

    public Indexer.IndexerType getIndexerType() {
        return Indexer.IndexerType.NAMEDFIELDS;
    }

    public ListeningExecutorService executorService() {
        return this.executorService;
    }

    public void setSearchIndexType(String searchIndexType) {
        this.searchIndexType = searchIndexType;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getSearchIndexType() {
        return this.searchIndexType;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

