/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.AbstractPropReadingTask;
import org.fedorahosted.tennera.antgettext.DirUtil;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.HeaderUtil;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoWriter;

public abstract class AbstractProp2PoPotTask
extends AbstractPropReadingTask {
    private FileNameMapper mapper;

    public void add(FileNameMapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("mapper already set!");
        }
        this.mapper = mapper;
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    abstract FileNameMapper defaultMapper();

    abstract FileSelector[] getSelectors();

    void checkArgs() {
        DirUtil.checkDir(this.srcDir, "srcDir", false);
        DirUtil.checkDir(this.dstDir, "dstDir", true);
        if (this.mapper == null) {
            this.mapper = this.defaultMapper();
        }
    }

    public void execute() throws BuildException {
        this.checkArgs();
        try {
            DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
            if (!this.getImplicitFileSet().hasPatterns()) {
                ds.setIncludes(new String[]{"**/*.properties"});
            }
            ds.setSelectors(this.getSelectors());
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                this.processFile(files[i]);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    abstract void processFile(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generatePO(File englishFile, Properties englishProps, File transFile, Properties transProps, File toPoFile) throws IOException {
        int messageCount = 0;
        toPoFile.getParentFile().mkdirs();
        BufferedWriter out = new BufferedWriter(new FileWriter(toPoFile));
        try {
            Catalog cat = new Catalog(true);
            int nonTranslatable = 0;
            for (String key : englishProps.stringPropertyNames()) {
                String comment;
                String englishString = englishProps.getProperty(key);
                if (this.shouldSkip(englishFile.toString(), key, englishString)) continue;
                if (this.includeAll) {
                    comment = englishProps.getComment(key);
                } else {
                    String raw = englishProps.getRawComment(key);
                    if (raw != null && raw.length() != 0) {
                        StringBuilder sb = new StringBuilder(raw.length());
                        String[] lines = raw.split("(\r\n|\r|\n)");
                        for (int j = 0; j < lines.length; ++j) {
                            String line = lines[j];
                            if (line.startsWith("# START NON-TRANSLATABLE")) {
                                ++nonTranslatable;
                                continue;
                            }
                            if (line.startsWith("# END NON-TRANSLATABLE")) {
                                if (--nonTranslatable >= 0) continue;
                                throw new BuildException("Found '# END NON-TRANSLATABLE' without matching '# START NON-TRANSLATABLE': file=" + englishFile + " key=" + key);
                            }
                            if (nonTranslatable != 0) continue;
                            sb.append(Properties.cookCommentLine((String)line));
                            if (j + 1 >= lines.length) continue;
                            sb.append('\n');
                        }
                        comment = sb.toString();
                    } else {
                        comment = null;
                    }
                }
                if (nonTranslatable != 0) continue;
                Message message = new Message();
                if (comment != null) {
                    message.addExtractedComment(comment);
                }
                message.addSourceReference(key);
                message.addFormat("java-format");
                message.setMsgctxt(key);
                message.setMsgid(englishString);
                if (transProps != null) {
                    String translatedValue = transProps.getProperty(key);
                    message.setMsgstr(translatedValue != null ? translatedValue : "");
                }
                cat.addMessage(message);
                ++messageCount;
            }
            PoWriter writer = new PoWriter();
            Date potDate = new Date(englishFile.lastModified());
            cat.addMessage(HeaderUtil.generateDefaultHeader((Date)potDate));
            writer.write(cat, (Writer)out);
        }
        finally {
            out.close();
        }
        if (messageCount == 0) {
            toPoFile.delete();
        }
    }
}

