/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.fedorahosted.tennera.antgettext.DirUtil;
import org.fedorahosted.tennera.antgettext.EmptyStringPolicy;

public abstract class AbstractPropReadingTask
extends MatchingTask {
    protected static final String START_MARKER = "# START NON-TRANSLATABLE";
    protected static final String END_MARKER = "# END NON-TRANSLATABLE";
    protected File srcDir;
    protected File dstDir;
    protected boolean includeAll;
    EmptyStringPolicy emptyStringPolicy = EmptyStringPolicy.WARNANDSKIP;
    protected static final String NEWLINE_REGEX = "(\r\n|\r|\n)";

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDstDir(File dstDir) {
        this.dstDir = dstDir;
    }

    public void setIncludeAll(boolean includeAll) {
        this.includeAll = includeAll;
    }

    public void setWhenEmptyString(String policy) {
        this.emptyStringPolicy = EmptyStringPolicy.valueOf(policy.toUpperCase());
    }

    protected void initialise() throws FileNotFoundException, RecognitionException, TokenStreamException, IOException {
        DirUtil.checkDir(this.srcDir, "srcDir", false);
        DirUtil.checkDir(this.dstDir, "dstDir", true);
    }

    protected DirectoryScanner getPropDirectoryScanner() {
        return this.getDirectoryScanner(this.srcDir);
    }

    protected boolean shouldSkip(String englishFile, String key, String englishString) {
        boolean skip = false;
        if (englishString.length() == 0) {
            String message = "Empty value for key " + key + " in file " + englishFile;
            switch (this.emptyStringPolicy) {
                case SKIP: {
                    this.log(message, 4);
                    skip = true;
                    break;
                }
                case WARNANDSKIP: {
                    this.log(message, 1);
                    skip = true;
                    break;
                }
                case INCLUDE: {
                    this.log(message, 4);
                    break;
                }
                case WARNANDINCLUDE: {
                    this.log(message, 1);
                    break;
                }
                case FAIL: {
                    throw new BuildException(message);
                }
                default: {
                    throw new RuntimeException("unhandled switch case " + (Object)((Object)this.emptyStringPolicy));
                }
            }
        }
        return skip;
    }
}

