/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.AbstractPropReadingTask;
import org.fedorahosted.tennera.antgettext.BasePropertiesSelector;
import org.fedorahosted.tennera.antgettext.DirMissingException;

public abstract class AbstractPropVisitingTask
extends AbstractPropReadingTask {
    String[] locales;

    public void setLocales(String locales) {
        this.locales = locales.split(",");
    }

    FileSelector[] getSelectors() {
        if (this.locales != null) {
            return new FileSelector[]{new BasePropertiesSelector(this.locales)};
        }
        return new FileSelector[0];
    }

    public void execute() throws BuildException {
        try {
            try {
                this.initialise();
            }
            catch (FileNotFoundException e) {
                this.log("skipped: " + e.getMessage(), 1);
                return;
            }
            this.dstDir.mkdirs();
            DirectoryScanner ds = this.getPropDirectoryScanner();
            if (!this.getImplicitFileSet().hasPatterns()) {
                ds.setIncludes(new String[]{"**/*.properties"});
            }
            ds.setSelectors(this.getSelectors());
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                this.processFile(files[i]);
            }
            this.postExecute();
        }
        catch (DirMissingException e) {
            this.log("skipped: " + e.getMessage());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    abstract void processFile(String var1) throws IOException;

    abstract void postExecute() throws IOException;

    protected void visitProperties(String englishFile, Properties englishProps, PropertiesVisitor visitor) throws IOException {
        int nonTranslatable = 0;
        for (String key : englishProps.stringPropertyNames()) {
            String comment;
            String englishString = englishProps.getProperty(key);
            if (this.includeAll) {
                comment = englishProps.getComment(key);
            } else {
                String raw = englishProps.getRawComment(key);
                if (raw != null && raw.length() != 0) {
                    StringBuilder sb = new StringBuilder(raw.length());
                    String[] lines = raw.split("(\r\n|\r|\n)");
                    for (int j = 0; j < lines.length; ++j) {
                        String line = lines[j];
                        if (line.startsWith("# START NON-TRANSLATABLE")) {
                            ++nonTranslatable;
                            continue;
                        }
                        if (line.startsWith("# END NON-TRANSLATABLE")) {
                            if (--nonTranslatable >= 0) continue;
                            throw new BuildException("Found \"# END NON-TRANSLATABLE\" without matching \"# START NON-TRANSLATABLE\" near " + englishFile + ":" + englishProps.getLineNumber(key));
                        }
                        if (nonTranslatable != 0) continue;
                        sb.append(Properties.cookCommentLine((String)line));
                        if (j + 1 >= lines.length) continue;
                        sb.append('\n');
                    }
                    comment = sb.toString();
                } else {
                    comment = null;
                }
            }
            if (this.shouldSkip(englishFile, key, englishString) || nonTranslatable != 0) continue;
            visitor.visit(key, englishString, comment, englishFile, englishProps.getLineNumber(key));
        }
    }

    protected static interface PropertiesVisitor {
        public void visit(String var1, String var2, String var3, String var4, int var5);
    }
}

