/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.util.FileUtils;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.AbstractPropGettextTask;
import org.fedorahosted.tennera.antgettext.AbstractPropVisitingTask;
import org.fedorahosted.tennera.antgettext.StringUtil;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.ExtendedCatalogParser;

public class Gettext2PropTask
extends AbstractPropGettextTask {
    private File propSrcDir;

    public void setPropSrcDir(File propSrcDir) {
        this.propSrcDir = propSrcDir;
    }

    @Override
    protected void initialise() throws FileNotFoundException, RecognitionException, TokenStreamException, IOException {
        super.initialise();
        if (this.propSrcDir == null) {
            this.propSrcDir = this.dstDir;
        }
    }

    @Override
    protected DirectoryScanner getPropDirectoryScanner() {
        return this.getDirectoryScanner(this.propSrcDir);
    }

    @Override
    Catalog initPOCatalog(String locale) throws FileNotFoundException, IOException, RecognitionException, TokenStreamException {
        try {
            File poFile = new File(this.srcDir, locale + ".po");
            ExtendedCatalogParser parser = new ExtendedCatalogParser(poFile);
            parser.catalog();
            return parser.getCatalog();
        }
        catch (Exception e) {
            this.log(e.getMessage(), 1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processFile(String propFilename) throws IOException {
        String englishFile;
        File propFile = new File(this.propSrcDir, propFilename);
        try {
            englishFile = FileUtils.getRelativePath((File)this.relativeBase, (File)propFile);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Properties englishProps = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(propFile));
        try {
            englishProps.load((InputStream)in);
        }
        finally {
            in.close();
        }
        String propBasename = StringUtil.removeFileExtension(propFilename, ".properties");
        for (String locale : this.locales) {
            Catalog cat = (Catalog)this.poCatalogs.get(locale);
            if (cat == null) continue;
            String propTransBasename = propBasename + "_" + locale + ".properties";
            File propTransFile = new File(this.dstDir, propTransBasename);
            PropGenerator propGenerator = new PropGenerator(cat);
            this.visitProperties(englishFile, englishProps, propGenerator);
            Properties props = propGenerator.getProperties();
            if (props.size() != 0) {
                propTransFile.getParentFile().mkdirs();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(propTransFile));
                try {
                    props.store((OutputStream)out, null);
                    continue;
                }
                finally {
                    out.close();
                }
            }
            propTransFile.delete();
        }
    }

    @Override
    void postExecute() throws IOException {
    }

    static class PropGenerator
    implements AbstractPropVisitingTask.PropertiesVisitor {
        private final Catalog cat;
        Properties properties = new Properties();

        public PropGenerator(Catalog cat) {
            this.cat = cat;
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public void visit(String key, String englishString, String comment, String englishFile, int lineNumber) {
            String msgstr;
            String msgctxt = key;
            String msgid = englishString;
            Message message = this.cat.locateMessage(msgctxt, msgid);
            if (message != null && !message.isFuzzy() && (msgstr = message.getMsgstr()) != null && msgstr.length() != 0) {
                this.properties.setProperty(key, msgstr);
            }
        }
    }
}

