/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.fedorahosted.tennera.antgettext.DirUtil;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoWriter;
import org.xml.sax.SAXException;

public abstract class MatchExtractingTask
extends MatchingTask {
    private BufferedWriter out;
    private File srcDir;
    private File target;
    private String pathPrefix = "";
    private String format = "";
    private Map<String, Set<String>> mapKeyToLocationSet = new TreeMap<String, Set<String>>();

    protected static int findLineNumber(Integer[] lineStarts, int charNo) {
        int position = Arrays.binarySearch((Object[])lineStarts, (Object)charNo);
        if (position >= 0) {
            return position + 1;
        }
        return -position - 1;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setPathPrefix(String prefix) {
        this.pathPrefix = prefix;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void execute() throws BuildException {
        DirUtil.checkDir(this.srcDir, "srcDir", false);
        if (this.target != null && this.target.exists() && !this.target.isFile()) {
            throw new BuildException("target exists but is not a file!");
        }
        try {
            DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            this.log("Files to scan: " + files.length, 3);
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i];
                this.log("processing " + filename, 3);
                File f = new File(this.srcDir, filename);
                this.processFile(filename, f);
            }
            if (this.mapKeyToLocationSet.isEmpty()) {
                this.log("No matching English strings found in '" + this.srcDir + "'", 3);
                return;
            }
            if (this.target == null) {
                this.log("Extracting " + this.mapKeyToLocationSet.size() + " English strings from '" + this.srcDir + "' to STDOUT", 3);
                this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
                this.generatePot(this.out);
            } else {
                this.target.getParentFile().mkdirs();
                this.log("Extracting " + this.mapKeyToLocationSet.size() + " English strings from '" + this.srcDir + "' to '" + this.target + "'", 3);
                this.out = new BufferedWriter(new FileWriter(this.target));
                this.generatePot(this.out);
                this.out.close();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected abstract void processFile(String var1, File var2) throws IOException, SAXException;

    protected void recordMatch(String filename, String key, String location) {
        Set<String> set = this.mapKeyToLocationSet.get(key);
        if (set == null) {
            set = new TreeSet<String>();
            this.mapKeyToLocationSet.put(key, set);
        }
        set.add(filename + ':' + location);
    }

    private void generatePot(BufferedWriter out) throws IOException {
        Catalog cat = new Catalog(true);
        for (Map.Entry<String, Set<String>> mapEntry : this.mapKeyToLocationSet.entrySet()) {
            Message message = new Message();
            Set<String> locations = mapEntry.getValue();
            for (String location : locations) {
                message.addSourceReference(this.pathPrefix + location);
            }
            if (!this.format.equals("")) {
                message.addFormat(this.format);
            }
            message.setMsgid(mapEntry.getKey());
            cat.addMessage(message);
        }
        PoWriter writer = new PoWriter();
        writer.setGenerateHeader(true);
        writer.write(cat, (Writer)out);
    }
}

