/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.DirUtil;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.MessageProcessor;
import org.fedorahosted.tennera.jgettext.catalog.parse.MessageStreamParser;

public class Po2PropTask
extends MatchingTask {
    private static final boolean INCLUDE_PROCESSING_COMMENT = false;
    private static final boolean INCLUDE_MESSAGE_COMMENTS = true;
    private File srcDir;
    private File dstDir;
    private Mapper mapper;
    private String locale = null;
    private boolean failOnNull = false;

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("mapper already set!");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper filenameMapper) {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(filenameMapper);
        this.addMapper(mapper);
    }

    public void setDstDir(File dstDir) {
        this.dstDir = dstDir;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setFailOnNull(boolean failOnNull) {
        this.failOnNull = failOnNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        DirUtil.checkDir(this.srcDir, "srcDir", false);
        DirUtil.checkDir(this.dstDir, "dstDir", true);
        String localeSuffix = this.locale == null || this.locale.length() == 0 ? "" : "_" + this.locale;
        if (this.mapper == null) {
            GlobPatternMapper globMap = new GlobPatternMapper();
            globMap.setFrom("*.po");
            globMap.setTo("*" + localeSuffix + ".properties");
            this.add((FileNameMapper)globMap);
        }
        try {
            DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
            if (!this.getImplicitFileSet().hasPatterns()) {
                ds.setIncludes(new String[]{"**/*.po"});
            }
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String poFilename = files[i];
                File poFile = new File(this.srcDir, poFilename);
                String[] outFile = this.mapper.getImplementation().mapFileName(poFilename);
                if (outFile == null || outFile.length == 0) {
                    if (this.failOnNull) {
                        throw new BuildException("Input filename " + poFilename + " mapped to null");
                    }
                    this.log("Skipping " + poFilename + ": filename mapped to null", 3);
                    continue;
                }
                String propFilename = outFile[0];
                File propFile = new File(this.dstDir, propFilename);
                if (propFile.lastModified() > poFile.lastModified()) {
                    this.log("Skipping " + poFilename + ": " + propFile.getPath() + " is up to date", 3);
                    continue;
                }
                final Properties props = new Properties();
                this.log("Generating " + propFile + " from " + poFile, 3);
                propFile.getParentFile().mkdirs();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(propFile));
                try {
                    MessageStreamParser parser = new MessageStreamParser(poFile);
                    MessageProcessor processor = new MessageProcessor(){

                        public void processMessage(Message entry) {
                            if (entry.isFuzzy()) {
                                return;
                            }
                            String ctxt = entry.getMsgctxt();
                            Collection poComments = entry.getExtractedComments();
                            StringBuilder sb = new StringBuilder();
                            for (String comm : poComments) {
                                sb.append(comm).append("\n");
                            }
                            String poComment = sb.toString();
                            Po2PropTask.this.log("Processing " + entry.toString(), 4);
                            if (ctxt == null) {
                                if (entry.getMsgid().length() != 0) {
                                    for (String ref : entry.getSourceReferences()) {
                                        props.setProperty(ref, entry.getMsgstr());
                                        if (poComment.length() == 0) continue;
                                        props.setComment(ref, poComment);
                                    }
                                }
                            } else {
                                props.setProperty(ctxt, entry.getMsgstr());
                                if (poComment.length() != 0) {
                                    props.setComment(ctxt, poComment);
                                }
                            }
                        }
                    };
                    while (parser.hasNext()) {
                        processor.processMessage(parser.next());
                    }
                    String comment = null;
                    props.store((OutputStream)out, comment);
                    continue;
                }
                finally {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

