/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.fedorahosted.tennera.antgettext.DirUtil;
import org.fedorahosted.tennera.antgettext.StringUtil;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.MessageProcessor;
import org.fedorahosted.tennera.jgettext.PoWriter;
import org.fedorahosted.tennera.jgettext.catalog.parse.ExtendedCatalogParser;

public class Pot2EnTask
extends MatchingTask {
    private File srcDir;
    private File dstDir;
    private String locale;
    private boolean pseudo;

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDstDir(File dstDir) {
        this.dstDir = dstDir;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setPseudo(boolean munge) {
        this.pseudo = munge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        DirUtil.checkDir(this.srcDir, "srcDir", false);
        if (this.dstDir == null) {
            this.dstDir = this.srcDir;
        }
        if (this.dstDir.equals(this.srcDir) && this.locale == null) {
            throw new BuildException();
        }
        DirUtil.checkDir(this.dstDir, "dstDir", true);
        try {
            DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
            if (!this.getImplicitFileSet().hasPatterns()) {
                ds.setIncludes(new String[]{"**/*.pot"});
            }
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File poFile;
                String potFilename = files[i];
                File potFile = new File(this.srcDir, potFilename);
                if (this.locale != null) {
                    File fileDest = new File(this.dstDir, potFilename).getParentFile();
                    poFile = new File(fileDest, this.locale + ".po");
                } else {
                    String poFilename = potFilename.substring(0, potFilename.length() - "pot".length()) + "po";
                    poFile = new File(this.dstDir, poFilename);
                }
                if (poFile.lastModified() > potFile.lastModified()) {
                    this.log("Skipping " + potFilename + ": " + poFile.getPath() + " is up to date", 3);
                    continue;
                }
                this.log("Generating " + poFile + " from " + potFile, 3);
                poFile.getParentFile().mkdirs();
                BufferedWriter out = new BufferedWriter(new FileWriter(poFile));
                try {
                    ExtendedCatalogParser parser = new ExtendedCatalogParser(potFile);
                    parser.catalog();
                    Catalog catalog = parser.getCatalog();
                    catalog.setTemplate(false);
                    MessageProcessor processor = new MessageProcessor(){

                        public void processMessage(Message entry) {
                            if (!entry.isHeader()) {
                                String msgid = entry.getMsgid();
                                if (Pot2EnTask.this.pseudo) {
                                    entry.setMsgstr(StringUtil.pseudolocalise(msgid));
                                } else {
                                    entry.setMsgstr(msgid);
                                }
                            }
                        }
                    };
                    catalog.processMessages(processor);
                    new PoWriter().write(catalog, poFile);
                    continue;
                }
                finally {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

