/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.tools.ant.util.FileUtils;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.AbstractPropGettextTask;
import org.fedorahosted.tennera.antgettext.AbstractPropVisitingTask;
import org.fedorahosted.tennera.antgettext.StringUtil;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoWriter;

public class Prop2GettextTask
extends AbstractPropGettextTask {
    boolean generatePO = true;
    boolean generatePOT = true;
    private Catalog potCatalog = new Catalog(true);

    public void setPO(boolean generatePO) {
        this.generatePO = generatePO;
    }

    public void setPOT(boolean generatePOT) {
        this.generatePOT = generatePOT;
    }

    @Override
    Catalog initPOCatalog(String locale) throws FileNotFoundException, IOException, RecognitionException, TokenStreamException {
        return new Catalog(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCat(Catalog cat, File poFile) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(poFile));
        try {
            PoWriter writer = new PoWriter();
            writer.setGenerateHeader(true);
            writer.write(cat, (Writer)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processFile(String propFilename) throws IOException {
        String englishFile;
        File propFile = new File(this.srcDir, propFilename);
        String propBasename = StringUtil.removeFileExtension(propFilename, ".properties");
        ArrayList<File> propTransFiles = new ArrayList<File>(this.locales.length);
        ArrayList<String> transLocales = new ArrayList<String>(this.locales.length);
        for (String locale : this.locales) {
            String propTransBasename = propBasename + "_" + locale + ".properties";
            File propTransFile = new File(this.srcDir, propTransBasename);
            if (propTransFile.exists()) {
                this.log(propTransFile + " added to list");
                propTransFiles.add(propTransFile);
                transLocales.add(locale);
                continue;
            }
            this.log(propTransFile + " does not exist");
        }
        if (propTransFiles.isEmpty() && !this.generatePOT) {
            return;
        }
        try {
            englishFile = FileUtils.getRelativePath((File)this.relativeBase, (File)propFile);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Properties englishProps = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(propFile));
        try {
            englishProps.load((InputStream)in);
        }
        finally {
            in.close();
        }
        if (this.generatePOT) {
            this.visitProperties(englishFile, englishProps, new POGenerator(this.potCatalog, null));
        }
        for (int k = 0; k < propTransFiles.size(); ++k) {
            File propTransFile = (File)propTransFiles.get(k);
            String locale = (String)transLocales.get(k);
            this.log("Reading messages from " + propFile + " and " + propTransFile, 3);
            Properties transProps = new Properties();
            BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(propTransFile));
            try {
                transProps.load((InputStream)in2);
            }
            finally {
                in2.close();
            }
            Catalog poCat = (Catalog)this.poCatalogs.get(locale);
            this.visitProperties(englishFile, englishProps, new POGenerator(poCat, transProps));
        }
    }

    @Override
    void postExecute() throws IOException {
        if (this.generatePO) {
            for (String locale : this.locales) {
                Catalog cat = (Catalog)this.poCatalogs.get(locale);
                File poFile = new File(this.dstDir, locale + ".po");
                if (cat.isEmpty()) {
                    poFile.delete();
                    continue;
                }
                this.saveCat(cat, poFile);
            }
        }
        if (this.generatePOT) {
            File potFile = new File(this.dstDir, this.dstDir.getName() + ".pot");
            this.saveCat(this.potCatalog, potFile);
        }
    }

    static class POGenerator
    implements AbstractPropVisitingTask.PropertiesVisitor {
        private final Catalog cat;
        private final Properties transProps;

        public POGenerator(Catalog cat, Properties transProps) {
            this.cat = cat;
            this.transProps = transProps;
        }

        @Override
        public void visit(String key, String englishString, String comment, String englishFile, int lineNumber) {
            String msgctxt = key;
            String msgid = englishString;
            Message message = this.cat.locateMessage(msgctxt, msgid);
            if (message != null) {
                if (this.transProps != null) assert (StringUtil.equals(message.getMsgstr(), this.transProps.getProperty(key)));
            } else {
                String msgstr;
                message = new Message();
                message.addFormat("java-format");
                message.addSourceReference(msgctxt);
                message.setMsgid(msgid);
                message.setMsgctxt(msgctxt);
                if (this.transProps != null && (msgstr = this.transProps.getProperty(key)) != null) {
                    message.setMsgstr(msgstr);
                }
                this.cat.addMessage(message);
            }
            if (comment != null) {
                message.addExtractedComment(comment);
            }
            message.addSourceReference(englishFile, lineNumber);
        }
    }
}

