/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.AbstractProp2PoPotTask;
import org.fedorahosted.tennera.antgettext.BasePropertiesSelector;
import org.fedorahosted.tennera.antgettext.StringUtil;

public class Prop2PoTask
extends AbstractProp2PoPotTask {
    private String[] locales;
    File srcTransDir;

    public void setLocales(String locales) {
        this.locales = locales.split(",");
    }

    public void setSrcTransDir(File srcTransDir) {
        this.srcTransDir = srcTransDir;
    }

    @Override
    FileNameMapper defaultMapper() {
        GlobPatternMapper globMap = new GlobPatternMapper();
        globMap.setFrom("*.properties");
        globMap.setTo("*.po");
        return globMap;
    }

    @Override
    FileSelector[] getSelectors() {
        return new FileSelector[]{new BasePropertiesSelector(this.locales)};
    }

    @Override
    void checkArgs() {
        super.checkArgs();
        if (this.locales == null) {
            throw new BuildException("locales attribute must be set!");
        }
        if (this.srcTransDir == null) {
            this.srcTransDir = this.srcDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processFile(String propFilename) throws IOException {
        File propFile = new File(this.srcDir, propFilename);
        String propBasename = StringUtil.removeFileExtension(propFilename, ".properties");
        ArrayList<File> propTransFiles = new ArrayList<File>(this.locales.length);
        ArrayList<File> poFiles = new ArrayList<File>(this.locales.length);
        for (String locale : this.locales) {
            String propTransBasename = propBasename + "_" + locale + ".properties";
            File propTransFile = new File(this.srcTransDir, propTransBasename);
            if (propTransFile.exists()) {
                String[] outFile = this.getMapper().mapFileName(propTransBasename);
                if (outFile == null || outFile.length == 0) {
                    this.log("Skipping " + propTransFile + ": filename mapped to null", 3);
                    return;
                }
                File poFile = new File(this.dstDir, outFile[0]);
                if (poFile.lastModified() > propFile.lastModified() && poFile.lastModified() > propTransFile.lastModified()) {
                    this.log("Skipping " + propTransFile.getName() + ": " + poFile.getPath() + " is up to date", 3);
                    continue;
                }
                this.log(propTransFile + " added to list");
                propTransFiles.add(propTransFile);
                poFiles.add(poFile);
                continue;
            }
            this.log(propTransFile + " does not exist");
        }
        if (propTransFiles.isEmpty()) {
            return;
        }
        Properties englishProps = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(propFile));
        try {
            englishProps.load((InputStream)in);
        }
        finally {
            in.close();
        }
        for (int k = 0; k < propTransFiles.size(); ++k) {
            File propTransFile = (File)propTransFiles.get(k);
            File poFile = (File)poFiles.get(k);
            this.log("Generating " + poFile + " from " + propFile + " and " + propTransFile, 3);
            Properties transProps = new Properties();
            BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(propTransFile));
            try {
                transProps.load((InputStream)in2);
            }
            finally {
                in2.close();
            }
            this.generatePO(propFile, englishProps, propTransFile, transProps, poFile);
        }
    }
}

