/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.fedorahosted.openprops.Properties;
import org.fedorahosted.tennera.antgettext.AbstractProp2PoPotTask;

public class Prop2PotTask
extends AbstractProp2PoPotTask {
    @Override
    FileNameMapper defaultMapper() {
        GlobPatternMapper globMap = new GlobPatternMapper();
        globMap.setFrom("*.properties");
        globMap.setTo("*.pot");
        return globMap;
    }

    @Override
    FileSelector[] getSelectors() {
        return new FileSelector[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processFile(String propFilename) throws IOException {
        File propFile = new File(this.srcDir, propFilename);
        String[] outFile = this.getMapper().mapFileName(propFilename);
        if (outFile == null || outFile.length == 0) {
            this.log("Skipping " + propFilename + ": filename mapped to null", 3);
            return;
        }
        File potFile = new File(this.dstDir, outFile[0]);
        if (potFile.lastModified() > propFile.lastModified()) {
            this.log("Skipping " + propFilename + ": " + potFile.getPath() + " is up to date", 3);
            return;
        }
        Properties props = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(propFile));
        try {
            props.load((InputStream)in);
        }
        finally {
            in.close();
        }
        this.log("Generating " + potFile + " from " + propFile, 3);
        this.generatePO(propFile, props, null, null, potFile);
    }
}

