/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.fedorahosted.tennera.antgettext.MatchExtractingTask;

public class Regex2PotTask
extends MatchExtractingTask {
    private static final String DEFAULT_REGEX = null;
    private String regex = DEFAULT_REGEX;
    private boolean unescape = true;

    public Regex2PotTask() {
        this.setFormat("java-format");
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setUnescape(boolean unescape) {
        this.unescape = unescape;
    }

    Integer[] readByLines(BufferedReader reader, StringBuilder contents) throws IOException {
        String line;
        ArrayList<Integer> lineStartList = new ArrayList<Integer>();
        int lineNo = 0;
        int charNum = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNo;
            contents.append(line);
            contents.append('\n');
            lineStartList.add(charNum);
            charNum += line.length() + 1;
        }
        Integer[] lineStarts = lineStartList.toArray(new Integer[lineStartList.size()]);
        return lineStarts;
    }

    @Override
    protected void processFile(String filename, File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringBuilder contents = new StringBuilder();
        Integer[] lineStarts = this.readByLines(reader, contents);
        Pattern pat = Pattern.compile(this.regex);
        Matcher matcher = pat.matcher(contents);
        while (matcher.find()) {
            try {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String capture = matcher.group(i);
                    if (capture == null) continue;
                    String key = this.unescapeJava(capture);
                    int charNo = matcher.start(i);
                    int lineNo = Regex2PotTask.findLineNumber(lineStarts, charNo);
                    this.recordMatch(filename, key, String.valueOf(lineNo));
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private String unescapeJava(String key) {
        if (this.unescape) {
            return key.replaceAll("\\\\(.)", "$1");
        }
        return key;
    }
}

