/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.BufferedReader;
import java.io.InputStreamReader;

class StringUtil {
    private static final String alphabetEnglish = "abcdefghijklmnopqrstuvwxyz";
    private static final String alphabetMunged = "\u00e5\u042c\u00e7\u0111\u00e9\u03dd\u0581\u2c68\u00ee\u029d\u2c6a\u0140\u10dd\u0148\u00f8\uff50\u1574\u044f\u0161\u0167\u0574\u2c71\ud834\udf55\u1e8b\u0177\u017c";
    private static final int[] codepointsMunged = new int["\u00e5\u042c\u00e7\u0111\u00e9\u03dd\u0581\u2c68\u00ee\u029d\u2c6a\u0140\u10dd\u0148\u00f8\uff50\u1574\u044f\u0161\u0167\u0574\u2c71\ud834\udf55\u1e8b\u0177\u017c".codePointCount(0, "\u00e5\u042c\u00e7\u0111\u00e9\u03dd\u0581\u2c68\u00ee\u029d\u2c6a\u0140\u10dd\u0148\u00f8\uff50\u1574\u044f\u0161\u0167\u0574\u2c71\ud834\udf55\u1e8b\u0177\u017c".length())];

    StringUtil() {
    }

    public static String pseudolocalise(String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("[--- ");
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch < 'a' || ch > 'z') {
                sb.append(ch);
                continue;
            }
            int mungedCodePoint = codepointsMunged[ch - 97];
            sb.appendCodePoint(mungedCodePoint);
        }
        sb.append(" ---]");
        return sb.toString();
    }

    public static void chomp(StringBuilder sb) {
        StringUtil.chopIfMatch(sb, '\n');
        StringUtil.chopIfMatch(sb, '\r');
    }

    private static void chopIfMatch(StringBuilder sb, char ch) {
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) == ch) {
            sb.setLength(sb.length() - 1);
        }
    }

    public static String chomp(String input) {
        StringBuilder sb = new StringBuilder(input);
        StringUtil.chomp(sb);
        return sb.toString();
    }

    static String removeFileExtension(String filename, String extension) {
        if (!filename.endsWith(extension)) {
            throw new IllegalArgumentException("Filename '" + filename + "' should have extension '" + extension + "'");
        }
        String basename = filename.substring(0, filename.length() - extension.length());
        return basename;
    }

    static boolean equals(String a, String b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) != null) {
            System.out.println(StringUtil.pseudolocalise(line));
        }
    }

    static {
        for (int i = 0; i < alphabetEnglish.length(); ++i) {
            char ch = alphabetEnglish.charAt(i);
            StringUtil.codepointsMunged[ch - 97] = alphabetMunged.codePointAt(alphabetMunged.offsetByCodePoints(0, i));
        }
    }
}

