/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.util.FileNameMapper;

public class UnflattenMapper
implements FileNameMapper {
    private String from = "^([^/\\\\]+)[/\\\\]([^-]+)-([^/\\\\]+)[/\\\\](.*)[.]po$";
    private Pattern pattern;

    public UnflattenMapper() {
        this.recompile();
    }

    private void recompile() {
        this.pattern = Pattern.compile(this.from);
    }

    public void setFrom(String from) {
        this.from = from;
        this.recompile();
    }

    public void setTo(String to) {
    }

    public String[] mapFileName(String sourceFileName) {
        Matcher m = this.pattern.matcher(sourceFileName);
        if (m.matches()) {
            StringBuilder sb = new StringBuilder();
            String module = m.group(1);
            String bundle = m.group(2);
            String resource = m.group(3);
            String locale = m.group(4);
            sb.append(module).append('/');
            sb.append(bundle).append('/');
            sb.append(resource.replace('.', '/'));
            sb.append('_').append(locale);
            sb.append(".properties");
            return new String[]{sb.toString()};
        }
        return null;
    }
}

