/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.fedorahosted.tennera.antgettext.DirUtil;

public class VerifyPropTask
extends MatchingTask {
    private File dir1;
    private File dir2;
    private Mapper mapper;
    private boolean failOnNull = false;
    private boolean failFast = false;
    private boolean keysOnly = false;

    public void setDir1(File srcDir) {
        this.dir1 = srcDir;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("mapper already set!");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper filenameMapper) {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(filenameMapper);
        this.addMapper(mapper);
    }

    public void setDir2(File dstDir) {
        this.dir2 = dstDir;
    }

    public void setFailOnNull(boolean failOnSkip) {
        this.failOnNull = failOnSkip;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setKeysOnly(boolean keysOnly) {
        this.keysOnly = keysOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        DirUtil.checkDir(this.dir1, "dir1", false);
        DirUtil.checkDir(this.dir2, "dir2", false);
        if (this.mapper == null) {
            this.add((FileNameMapper)new IdentityMapper());
        }
        try {
            DirectoryScanner ds = super.getDirectoryScanner(this.dir1);
            if (!this.getImplicitFileSet().hasPatterns()) {
                ds.setIncludes(new String[]{"**/*.properties"});
            }
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String prop1Filename = files[i];
                File prop1File = new File(this.dir1, prop1Filename);
                String[] outFile = this.mapper.getImplementation().mapFileName(prop1Filename);
                if (outFile == null || outFile.length == 0) {
                    if (this.failOnNull) {
                        throw new BuildException("Input filename " + prop1File + " mapped to null");
                    }
                    this.log("Skipping " + prop1File + ": filename mapped to null", 3);
                    continue;
                }
                String prop2Filename = outFile[0];
                File prop2File = new File(this.dir2, prop2Filename);
                Properties props1 = new Properties();
                FileInputStream in1 = new FileInputStream(prop1File);
                try {
                    props1.load(in1);
                    Properties props2 = new Properties();
                    FileInputStream in2 = new FileInputStream(prop2File);
                    try {
                        props2.load(in2);
                        int errorCount = 0;
                        StringBuilder errors = new StringBuilder();
                        errors.append(prop1File.getPath() + " is different from " + prop2File.getPath() + ": ");
                        errors.append(System.getProperty("line.separator"));
                        for (Map.Entry<Object, Object> entry : props1.entrySet()) {
                            String prop2Val;
                            String propName = (String)entry.getKey();
                            String prop1Val = (String)entry.getValue();
                            if (this.equivalent(prop1Val, prop2Val = (String)props2.remove(propName))) continue;
                            ++errorCount;
                            this.recordError(errors, propName + " -> {" + prop1Val + ", " + prop2Val + "}");
                        }
                        if (!props2.isEmpty()) {
                            ++errorCount;
                            String message = "second file contains extra keys: " + props2.keySet();
                            this.recordError(errors, message);
                        }
                        if (errorCount == 0) continue;
                        throw new BuildException(errors.toString());
                    }
                    finally {
                        ((InputStream)in2).close();
                    }
                }
                finally {
                    ((InputStream)in1).close();
                }
            }
            this.log("Verified .properties files in " + this.dir1 + " against " + this.dir2, 3);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean equivalent(String prop1Val, String prop2Val) {
        if (this.keysOnly) {
            return prop2Val != null;
        }
        return prop1Val.equals(prop2Val);
    }

    private void recordError(StringBuilder errors, String message) {
        errors.append(message);
        if (this.failFast) {
            throw new BuildException(errors.toString());
        }
        errors.append(System.getProperty("line.separator"));
    }
}

