/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.antgettext;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ResourceLocation;
import org.apache.tools.ant.types.XMLCatalog;
import org.fedorahosted.tennera.antgettext.MatchExtractingTask;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPath2PotTask
extends MatchExtractingTask {
    private String xpath;
    private XMLCatalog xmlCatalog = new XMLCatalog();

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void addDTD(ResourceLocation dtd) throws BuildException {
        this.xmlCatalog.addDTD(dtd);
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    @Override
    protected void processFile(String filename, File f) throws SAXException, IOException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = this.xpath;
        InputSource inputSource = new InputSource(f.getPath());
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            parser.setEntityResolver((EntityResolver)this.xmlCatalog);
            Document document = parser.parse(inputSource);
            NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String key = node.getTextContent();
                String position = XPath2PotTask.getXPathForElement(node, node.getOwnerDocument());
                this.recordMatch(filename, key, position);
            }
        }
        catch (XPathExpressionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static String getXPathForElement(Node el, Document doc) {
        String xpath = "";
        if (el.getNodeType() == 2) {
            Attr at = (Attr)el;
            el = at.getOwnerElement();
            xpath = at.getNamespaceURI() == null ? '@' + at.getName() : "attribute::*[local-name()='" + at.getLocalName() + "' and namespace-uri()='" + at.getNamespaceURI() + "']";
        }
        while (el != null && el != doc.getDocumentElement()) {
            int pos = 0;
            for (Node tempitem2 = el; tempitem2 != null; tempitem2 = tempitem2.getPreviousSibling()) {
                if (tempitem2.getNodeType() != 1 || !tempitem2.getNodeName().equals(el.getNodeName())) continue;
                ++pos;
            }
            xpath = XPath2PotTask.nodeToName(el) + '[' + pos + ']' + '/' + xpath;
            el = el.getParentNode();
        }
        if (el != null) {
            xpath = '/' + XPath2PotTask.nodeToName(el) + '/' + xpath;
        }
        if (xpath.endsWith("/")) {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        return xpath;
    }

    private static String nodeToName(Node el) {
        if (el.getNamespaceURI() == null) {
            return el.getNodeName();
        }
        return "*[local-name()='" + el.getLocalName() + "' and namespace-uri()='" + el.getNamespaceURI() + "']";
    }
}

