/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderFields {
    private Map<String, String> entries = new LinkedHashMap<String, String>();
    public static final String KEY_ProjectIdVersion = "Project-Id-Version";
    public static final String KEY_ReportMsgidBugsTo = "Report-Msgid-Bugs-To";
    public static final String KEY_PotCreationDate = "POT-Creation-Date";
    public static final String KEY_PoRevisionDate = "PO-Revision-Date";
    public static final String KEY_LastTranslator = "Last-Translator";
    public static final String KEY_LanguageTeam = "Language-Team";
    public static final String KEY_MimeVersion = "MIME-Version";
    public static final String KEY_ContentType = "Content-Type";
    public static final String KEY_ContentTransferEncoding = "Content-Transfer-Encoding";
    public static final String KEY_Language = "Language";
    private static final Set<String> defaultKeys;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mmZ");
    private static final Pattern pluralPattern;
    private static final Pattern charsetPattern;

    public static Set<String> getDefaultKeys() {
        return defaultKeys;
    }

    public String getValue(String key) {
        return this.entries.get(key);
    }

    public void setValue(String key, String value) {
        this.entries.put(key, value);
    }

    public void remove(String key) {
        this.entries.remove(key);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public static HeaderFields wrap(Message message) throws ParseException {
        return HeaderFields.wrap(message.getMsgstr());
    }

    public static HeaderFields wrap(String msgstr) throws ParseException {
        String[] entries;
        HeaderFields header = new HeaderFields();
        if (msgstr.isEmpty()) {
            return header;
        }
        for (String entry : entries = msgstr.split("\n")) {
            String[] keyval = entry.split("\\:", 2);
            if (keyval.length != 2) {
                throw new ParseException("Could not parse header entry: " + entry, -1);
            }
            header.entries.put(keyval[0].trim(), keyval[1].trim());
        }
        return header;
    }

    public void unwrap(Message message) {
        StringBuilder msgstr = new StringBuilder();
        for (String key : this.getKeys()) {
            if (this.getValue(key) == null) continue;
            msgstr.append(key);
            msgstr.append(": ");
            msgstr.append(this.getValue(key));
            msgstr.append("\n");
        }
        message.setMsgstr(msgstr.toString());
    }

    public Message unwrap() {
        Message header = new Message();
        header.setMsgid("");
        header.setFuzzy(true);
        this.unwrap(header);
        return header;
    }

    public void updatePORevisionDate() {
        this.setValue(KEY_PoRevisionDate, this.dateFormat.format(new Date()));
    }

    public void updatePOTCreationDate() {
        this.setValue(KEY_PotCreationDate, this.dateFormat.format(new Date()));
    }

    static {
        HashSet<String> keys = new HashSet<String>();
        keys.add(KEY_ProjectIdVersion);
        keys.add(KEY_ReportMsgidBugsTo);
        keys.add(KEY_PotCreationDate);
        keys.add(KEY_PoRevisionDate);
        keys.add(KEY_LastTranslator);
        keys.add(KEY_LanguageTeam);
        keys.add(KEY_MimeVersion);
        keys.add(KEY_ContentType);
        keys.add(KEY_ContentTransferEncoding);
        defaultKeys = Collections.unmodifiableSet(keys);
        pluralPattern = Pattern.compile("nplurals(\\s*?)=(\\s*?)(\\d*?)([\\\\|;|\\n])", 2);
        charsetPattern = Pattern.compile("(content-type)(\\s*?):(.*?)charset(\\s*?)=(\\s*?)(.*?)([\\\\|;|\\n])", 2);
    }
}

