/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext.catalog.parse;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.CatalogLexer;
import org.fedorahosted.tennera.jgettext.catalog.parse.CatalogParser;
import org.fedorahosted.tennera.jgettext.catalog.parse.ParseException;
import org.fedorahosted.tennera.jgettext.catalog.parse.UnexpectedTokenException;

public class ExtendedCatalogParser
extends CatalogParser {
    private final Catalog catalog;
    private Message currentMessage = new Message();

    public ExtendedCatalogParser(File file) throws FileNotFoundException, IOException {
        super(new CatalogLexer(file));
        this.catalog = new Catalog(ExtendedCatalogParser.isPot(file));
    }

    public ExtendedCatalogParser(Reader reader, boolean isPot) {
        super(new CatalogLexer(reader));
        this.catalog = new Catalog(isPot);
    }

    public ExtendedCatalogParser(InputStream inputStream, boolean isPot) throws IOException {
        super(new CatalogLexer(inputStream));
        this.catalog = new Catalog(isPot);
    }

    public ExtendedCatalogParser(InputStream inputStream, Charset charset, boolean isPot) {
        super(new CatalogLexer(inputStream, charset));
        this.catalog = new Catalog(isPot);
    }

    private static boolean isPot(File file) {
        return file.getName().toLowerCase().endsWith(".pot");
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void reportError(RecognitionException e) {
        UnexpectedTokenException utEx = new UnexpectedTokenException(e.getMessage(), e.getLine());
        utEx.initCause(e);
        throw utEx;
    }

    public void reportError(String s) {
        throw new ParseException("error parsing catalog : " + s, -1);
    }

    public void reportWarning(String s) {
    }

    @Override
    protected void handleMessageBlock(AST messageBlock) {
        this.catalog.addMessage(this.currentMessage);
        this.currentMessage = new Message();
    }

    @Override
    protected void handleObsoleteMessageBlock(AST messageBlock) {
        this.currentMessage.markObsolete();
        this.handleMessageBlock(messageBlock);
    }

    @Override
    protected void handleCatalogComment(AST comment) {
        this.currentMessage.addComment(this.extractText(comment));
    }

    @Override
    protected void handleExtractedComment(AST comment) {
        this.currentMessage.addExtractedComment(this.extractText(comment));
    }

    @Override
    protected void handleReference(AST sourceRef) {
        this.currentMessage.addSourceReference(this.parseSourceReference(sourceRef));
    }

    @Override
    protected void handleFlag(AST flag) {
        String[] flags;
        for (String flagStr : flags = flag.getText().split(",")) {
            if ((flagStr = flagStr.trim()).isEmpty()) continue;
            this.currentMessage.addFormat(flagStr);
        }
    }

    @Override
    protected void handlePreviousMsgctxt(AST previousMsgctxt) {
        this.currentMessage.setPrevMsgctx(this.extractText(previousMsgctxt));
    }

    @Override
    protected void handlePreviousMsgid(AST previousMsgid) {
        this.currentMessage.setPrevMsgid(this.extractText(previousMsgid));
    }

    @Override
    protected void handlePreviousMsgidPlural(AST previousMsgidPlural) {
        this.currentMessage.setPrevMsgidPlural(this.extractText(previousMsgidPlural));
    }

    @Override
    protected void handleDomain(AST domain) {
        this.currentMessage.setDomain(this.extractText(domain));
    }

    @Override
    protected void handleMsgctxt(AST msgctxt) {
        this.currentMessage.setMsgctxt(this.extractText(msgctxt));
    }

    @Override
    protected void handleMsgid(AST msgid) {
        this.currentMessage.setMsgid(this.extractText(msgid));
    }

    @Override
    protected void handleMsgidPlural(AST msgidPlural) {
        this.currentMessage.setMsgidPlural(this.extractText(msgidPlural));
    }

    @Override
    protected void handleMsgstr(AST msgstr) {
        this.currentMessage.setMsgstr(this.extractText(msgstr));
    }

    @Override
    protected void handleMsgstrPlural(AST msgstr, AST plurality) {
        this.currentMessage.addMsgstrPlural(this.extractText(msgstr), Integer.parseInt(plurality.getText()));
    }

    private String extractText(AST ast) {
        return ast == null ? "" : ast.getText();
    }

    private String parseSourceReference(AST ast) {
        return ast.getText();
    }
}

