/*
 * Decompiled with CFR 0.152.
 */
package org.fernice.reflare.internal.impl;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.MultiResolutionImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.fernice.reflare.internal.ImageHelper;

public class ImageAccessorImpl
implements ImageHelper.ImageAccessor {
    public Image getMultiResolutionImageResource(String resource) throws IOException {
        BufferedImage image;
        try (InputStream inputStream = ImageAccessorImpl.class.getResourceAsStream(resource);){
            image = ImageIO.read(inputStream);
        }
        String resource2x = resource.substring(0, resource.lastIndexOf(46)) + "@2x" + resource.substring(resource.lastIndexOf("."));
        try (InputStream input2x = ImageAccessorImpl.class.getResourceAsStream(resource2x);){
            if (input2x != null) {
                BufferedImage image2x = ImageIO.read(input2x);
                BaseMultiResolutionImage baseMultiResolutionImage = new BaseMultiResolutionImage(image, image2x);
                return baseMultiResolutionImage;
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
    }

    public Image getScaledInstance(Image image, int width, int height, int hints) {
        if (image.getWidth(null) == width && image.getHeight(null) == height) {
            return image;
        }
        if (image instanceof MultiResolutionImage) {
            MultiResolutionImage multiResolutionImage = (MultiResolutionImage)((Object)image);
            List<Image> images = multiResolutionImage.getResolutionVariants();
            Image base = images.get(0).getScaledInstance(width, height, hints);
            Image variant = images.get(1).getScaledInstance(width * 2, height * 2, hints);
            return new BaseMultiResolutionImage(base, variant);
        }
        return image.getScaledInstance(width, height, hints);
    }

    public Image getFilteredInstance(Image image, ImageFilter filter) {
        if (image instanceof MultiResolutionImage) {
            MultiResolutionImage multiResolutionImage = (MultiResolutionImage)((Object)image);
            List<Image> images = multiResolutionImage.getResolutionVariants();
            Image base = this.getFilteredInstance0(images.get(0), filter);
            Image variant = this.getFilteredInstance(images.get(1), filter);
            return new BaseMultiResolutionImage(base, variant);
        }
        return this.getFilteredInstance0(image, filter);
    }

    private Image getFilteredInstance0(Image image, ImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }
}

