/*
 * Decompiled with CFR 0.152.
 */
package org.fernice.reflare.internal.impl;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.swing.SwingAccessor;

public class ScreenPopupFactory
extends PopupFactory {
    public static final String WINDOW_DRAGGABLE_BACKGROUND = "apple.awt.draggableWindowBackground";
    public static final String WINDOW_ALPHA = "Window.alpha";
    public static final String WINDOW_SHADOW = "Window.shadow";
    public static final String WINDOW_SHADOW_REVALIDATE_NOW = "apple.awt.windowShadow.revalidateNow";
    public static final String WINDOW_FADE_DELEGATE = "apple.awt._windowFadeDelegate";
    static final Float TRANSLUCENT = Float.valueOf(0.972549f);
    static final Float OPAQUE = Float.valueOf(1.0f);
    boolean fIsActive = true;

    void setActive(boolean b) {
        this.fIsActive = b;
    }

    private static Window getWindow(Component c) {
        Component w;
        for (w = c; !(w instanceof Window) && w != null; w = w.getParent()) {
        }
        return (Window)w;
    }

    @Override
    public Popup getPopup(Component comp, Component invoker, int x, int y) {
        if (invoker == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        Popup popup = this.fIsActive ? SwingAccessor.getPopupFactoryAccessor().getHeavyWeightPopup(this, comp, invoker, x, y) : super.getPopup(comp, invoker, x, y);
        Window w = ScreenPopupFactory.getWindow(invoker);
        if (w == null) {
            return popup;
        }
        if (!(w instanceof RootPaneContainer)) {
            return popup;
        }
        final JRootPane popupRootPane = ((RootPaneContainer)((Object)w)).getRootPane();
        if (this.fIsActive) {
            popupRootPane.putClientProperty(WINDOW_ALPHA, OPAQUE);
            popupRootPane.putClientProperty(WINDOW_SHADOW, Boolean.TRUE);
            popupRootPane.putClientProperty(WINDOW_FADE_DELEGATE, invoker);
            w.setBackground(UIManager.getColor("PopupMenu.translucentBackground"));
            popupRootPane.putClientProperty(WINDOW_DRAGGABLE_BACKGROUND, Boolean.FALSE);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupRootPane.putClientProperty(ScreenPopupFactory.WINDOW_SHADOW_REVALIDATE_NOW, Math.random());
                }
            });
        } else {
            popupRootPane.putClientProperty(WINDOW_ALPHA, OPAQUE);
            popupRootPane.putClientProperty(WINDOW_SHADOW, Boolean.FALSE);
        }
        return popup;
    }
}

