/*
 * Decompiled with CFR 0.152.
 */
package org.fernice.reflare.internal.impl;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fernice.reflare.internal.SunFontHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.font.Font2D;
import sun.font.FontAccess;

public class SunFontAccessorImpl
implements SunFontHelper.SunFontAccessor {
    private static final String[] WEIGHT_NAMES = new String[]{"thin", "light", "ultralight", "ultra light", "ultra-light", "extralight", "extlt", "extra light", "extra-light", "demilight", "demi light", "demi-light", "normal", "regular", "medium", "med", "bold", "heavy", "black", "blk", "semibold", "sembd", "semi bold", "semi-bold", "demibold", "demi", "demi bold", "demi-bold", "extrabold", "extbd", "extra bold", "extra-bold", "ultrabold", "ultra bold", "ultra-bold"};
    private static final int MERGING_STRATEGY_COMBINE = 0;
    private static final int MERGING_STRATEGY_KEEP = 1;
    private static final int MERGING_STRATEGY_OVERRIDE = 2;
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static final CountDownLatch initializationLatch = new CountDownLatch(1);
    private static volatile Map<String, List<FontPeer>> fontFamilies = new HashMap<String, List<FontPeer>>();
    private static final Set<Font> fontExtensions = new HashSet<Font>();
    private static final Set<Font> fontExtensionOverrides = new HashSet<Font>();

    @Nullable
    public Font findFont(@NotNull String family, int weight, boolean italic) {
        if (!this.ensureInitialized(family)) {
            return null;
        }
        List<FontPeer> fontFamily = fontFamilies.get(family.toLowerCase());
        if (fontFamily != null && !fontFamily.isEmpty()) {
            int weightDistance = Integer.MAX_VALUE;
            Font matchingFont = null;
            for (FontPeer font : fontFamily) {
                int distance;
                boolean fontItalic = font.font2D.getStyle() == 2 || font.font2D.getStyle() == 3;
                if (fontItalic != italic || (distance = Math.abs(weight - font.font2D.getWeight())) >= weightDistance) continue;
                weightDistance = distance;
                matchingFont = font.font;
            }
            return matchingFont;
        }
        return null;
    }

    private boolean ensureInitialized(@NotNull String family) {
        if (!initialized.getAndSet(true)) {
            new Font(family, 3, 12);
            this.refresh();
            initializationLatch.countDown();
        } else {
            try {
                initializationLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean registerFontExtension(@NotNull Font font, boolean override) {
        if (override) {
            fontExtensions.remove(font);
            if (!fontExtensionOverrides.add(font)) {
                return false;
            }
        } else {
            fontExtensionOverrides.remove(font);
            if (!fontExtensions.add(font)) {
                return false;
            }
        }
        return this.recomputeFontFamilies(font);
    }

    public boolean unregisterFontExtension(@NotNull Font font) {
        boolean result = fontExtensions.remove(font);
        return result |= fontExtensionOverrides.remove(font);
    }

    public void refresh() {
        this.recomputeFontFamilies(null);
    }

    private boolean recomputeFontFamilies(@Nullable Font target) {
        HashMap<String, List<FontPeer>> fontFamilies = new HashMap<String, List<FontPeer>>();
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        boolean targetResult = this.mergeFontFamilies(fontFamilies, fonts, 0, target);
        Font[] fontExtensions = SunFontAccessorImpl.fontExtensions.toArray(new Font[0]);
        targetResult |= this.mergeFontFamilies(fontFamilies, fontExtensions, 1, target);
        Font[] fontExtensionOverrides = SunFontAccessorImpl.fontExtensionOverrides.toArray(new Font[0]);
        SunFontAccessorImpl.fontFamilies = fontFamilies;
        return targetResult |= this.mergeFontFamilies(fontFamilies, fontExtensionOverrides, 2, target);
    }

    private boolean mergeFontFamilies(@NotNull Map<String, List<FontPeer>> fontFamilies, @NotNull Font[] fonts, int mergingStrategy, @Nullable Font target) {
        boolean targetResult = false;
        for (Font font : fonts) {
            String familyName = font.getFamily().toLowerCase();
            List fontFamily = fontFamilies.computeIfAbsent(familyName, s -> new ArrayList());
            targetResult |= this.mergeFontFamily(fontFamily, font, mergingStrategy) && font == target;
            for (String weightName : WEIGHT_NAMES) {
                int index = familyName.indexOf(weightName);
                if (index < 0) continue;
                String strippedFamilyName = familyName.substring(0, index).trim();
                List additionalFontFamily = fontFamilies.computeIfAbsent(strippedFamilyName, s -> new ArrayList());
                targetResult |= this.mergeFontFamily(additionalFontFamily, font, mergingStrategy) && font == target;
            }
        }
        return targetResult;
    }

    private boolean mergeFontFamily(@NotNull List<FontPeer> fonts, @NotNull Font font, int mergingStrategy) {
        FontAccess fontAccess = FontAccess.getFontAccess();
        Font2D font2D = fontAccess.getFont2D(font);
        int fontWeight = font2D.getWeight();
        boolean fontItalic = font2D.getStyle() == 2 || font2D.getStyle() == 3;
        while (true) {
            FontPeer matchingFont = null;
            for (FontPeer candidateFont : fonts) {
                boolean candidateFontItalic;
                Font2D candidateFont2D = candidateFont.font2D;
                int candidateFontWeight = candidateFont2D.getWeight();
                boolean bl = candidateFontItalic = candidateFont2D.getStyle() == 2 || candidateFont2D.getStyle() == 3;
                if (candidateFontWeight != fontWeight || candidateFontItalic != fontItalic) continue;
                matchingFont = candidateFont;
                break;
            }
            if (matchingFont == null) break;
            if (mergingStrategy == 1) {
                return false;
            }
            if (mergingStrategy != 2) break;
            fonts.remove(matchingFont);
        }
        fonts.add(new FontPeer(font, font2D));
        return true;
    }

    public int getFontWeight(@NotNull Font font) {
        return FontAccess.getFontAccess().getFont2D(font).getWeight();
    }

    public boolean isFontItalic(@NotNull Font font) {
        int style = FontAccess.getFontAccess().getFont2D(font).getStyle();
        return style == 2 || style == 3;
    }

    private static final class FontPeer {
        @NotNull
        final Font font;
        @NotNull
        final Font2D font2D;

        private FontPeer(@NotNull Font font, @NotNull Font2D font2D) {
            this.font = font;
            this.font2D = font2D;
        }

        @NotNull
        public String toString() {
            return "Font[family=" + this.font.getFamily() + " name=" + this.font.getName() + " style=" + this.font2D.getStyle() + " weight=" + this.font2D.getWeight() + "]";
        }
    }
}

