/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeAdaptor {
    private Node node;

    private void setNode(Node node) {
        if (node == null) {
            throw new RuntimeException("Node being set in DataNodeAdaptor is null");
        }
        this.node = node;
    }

    private void throwNodeAdaptorNotFound(String elementName) {
        StringBuffer sp = new StringBuffer();
        sp.append("Element");
        sp.append(" \"");
        sp.append(elementName);
        sp.append("\"");
        sp.append(" not found.  Elements in node");
        sp.append(" \"");
        sp.append(this.getNode().getNodeName());
        sp.append("\"");
        sp.append(" are: ");
        NodeList list = this.getNode().getChildNodes();
        int ilen = list.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node found = list.item(i);
            if (1 != found.getNodeType()) continue;
            sp.append("\"");
            sp.append(found.getNodeName());
            sp.append("\"");
            sp.append(" ");
        }
        throw new RuntimeException(sp.toString());
    }

    public NodeAdaptor(Node node) {
        this.setNode(node);
    }

    public Node getNode() {
        return this.node;
    }

    public int getNodeAdaptorCount() {
        int count = 0;
        NodeList list = this.getNode().getChildNodes();
        int ilen = list.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node found = list.item(i);
            if (1 != found.getNodeType()) continue;
            ++count;
        }
        return count;
    }

    public String getName() {
        return this.getNode().getNodeName();
    }

    public int getType() {
        return this.getNode().getNodeType();
    }

    public String getValue() {
        String retval = null;
        if (this.getType() == 3) {
            retval = this.getNode().getNodeValue();
        } else if (this.getNode().getChildNodes().getLength() == 1) {
            Node zero = this.getNode().getChildNodes().item(0);
            if (zero.getNodeType() == 3) {
                retval = zero.getNodeValue();
            }
            Object var2_2 = null;
        }
        return retval;
    }

    public String getValueTrimmed() {
        String s = this.getValue();
        return s == null ? s : s.trim();
    }

    public NodeAdaptor getNodeAdaptor(String elementName) {
        if (this.getNode().getChildNodes().getLength() == 0) {
            throw new RuntimeException("DataNodeAdaptor's node has no children");
        }
        Node found = null;
        NodeList list = this.getNode().getChildNodes();
        int ilen = list.getLength();
        for (int i = 0; found == null && i < ilen; ++i) {
            found = list.item(i);
            if (1 == found.getNodeType() && found.getNodeName().equalsIgnoreCase(elementName)) continue;
            found = null;
        }
        if (found == null) {
            this.throwNodeAdaptorNotFound(elementName);
        }
        return new NodeAdaptor(found);
    }

    public List<NodeAdaptor> getNodeAdaptors(String elementName) {
        if (this.getNode().getChildNodes().getLength() == 0) {
            throw new RuntimeException("DataNodeAdaptor's node has no children");
        }
        ArrayList<NodeAdaptor> retval = new ArrayList<NodeAdaptor>();
        NodeList list = this.getNode().getChildNodes();
        int ilen = list.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node found = list.item(i);
            if (1 != found.getNodeType() || !found.getNodeName().equalsIgnoreCase(elementName)) continue;
            retval.add(new NodeAdaptor(found));
        }
        if (retval.isEmpty()) {
            this.throwNodeAdaptorNotFound(elementName);
        }
        return retval;
    }

    public boolean hasNodeAdaptor(String elementName) {
        if (this.getNode().getChildNodes().getLength() == 0) {
            return false;
        }
        boolean found = false;
        NodeList list = this.getNode().getChildNodes();
        int ilen = list.getLength();
        for (int i = 0; !found && i < ilen; ++i) {
            Node child = list.item(i);
            found = 1 == child.getNodeType() && child.getNodeName().equalsIgnoreCase(elementName);
        }
        return found;
    }
}

