/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.parser.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.ff4j.conf.FF4jConfiguration;
import org.ff4j.conf.FF4jConfigurationParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyString;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;

public class PropertiesParser
implements FF4jConfigurationParser<FF4jConfiguration> {
    private void addProperty(StringBuilder file, String key, Object value) {
        if (null == value) {
            value = "";
        }
        file.append(key + "=" + String.valueOf(value) + "\n");
    }

    private void exportProperty(StringBuilder output, String prefix, Property<?> p) {
        this.addProperty(output, prefix + "name", p.getName());
        this.addProperty(output, prefix + "type", p.getClass().getCanonicalName());
        this.addProperty(output, prefix + "value", p.asString());
        if (null != p.getFixedValues() && !p.getFixedValues().isEmpty()) {
            this.addProperty(output, prefix + "fixedValues", String.join((CharSequence)",", p.getFixedValues().stream().map(Object::toString).collect(Collectors.toSet())));
        }
    }

    public InputStream export(FF4jConfiguration ff4jConfig) {
        Util.assertNotNull((Object[])new Object[]{ff4jConfig});
        StringBuilder output = new StringBuilder();
        this.addProperty(output, "ff4j.audit", ff4jConfig.isAudit());
        this.addProperty(output, "ff4j.autocreate", ff4jConfig.isAutoCreate());
        if (null != ff4jConfig.getFeatures()) {
            int idxFeature = 0;
            for (Feature f : ff4jConfig.getFeatures().values()) {
                String prefixKey = "ff4j.features." + idxFeature + ".";
                this.addProperty(output, prefixKey + "uid", f.getUid());
                this.addProperty(output, prefixKey + "enable", f.isEnable());
                if (null != f.getDescription()) {
                    this.addProperty(output, prefixKey + "description", f.getDescription());
                }
                if (null != f.getGroup()) {
                    this.addProperty(output, prefixKey + "groupName", f.getGroup());
                }
                if (!f.getPermissions().isEmpty()) {
                    this.addProperty(output, prefixKey + "permissions", String.join((CharSequence)",", f.getPermissions()));
                }
                if (null != f.getFlippingStrategy()) {
                    String flipKey = prefixKey + "flipstrategy" + ".";
                    this.addProperty(output, flipKey + "class", String.join((CharSequence)",", f.getFlippingStrategy().getClass().getName()));
                    int idxParam = 0;
                    for (Map.Entry entry : f.getFlippingStrategy().getInitParams().entrySet()) {
                        this.addProperty(output, flipKey + "param" + "." + idxParam + "." + "name", entry.getKey());
                        this.addProperty(output, flipKey + "param" + "." + idxParam + "." + "value", entry.getValue());
                        ++idxParam;
                    }
                }
                if (!f.getCustomProperties().isEmpty()) {
                    int idxProps = 0;
                    for (Property p : f.getCustomProperties().values()) {
                        String propKey = prefixKey + "custom-properties" + "." + idxProps + ".";
                        this.exportProperty(output, propKey, p);
                        ++idxProps;
                    }
                }
                ++idxFeature;
            }
        }
        if (null != ff4jConfig.getProperties() && !ff4jConfig.getProperties().isEmpty()) {
            int idxProps = 0;
            for (Property p : ff4jConfig.getProperties().values()) {
                String propKey = "ff4j.properties." + idxProps + ".";
                this.exportProperty(output, propKey, p);
                ++idxProps;
            }
        }
        System.out.println(output.toString());
        return new ByteArrayInputStream(output.toString().getBytes(StandardCharsets.UTF_8));
    }

    public FF4jConfiguration parseSystemConfiguration() {
        return this.parseConfiguration(System.getProperties());
    }

    public FF4jConfiguration parseConfigurationFile(InputStream inputStream) {
        Util.assertNotNull((Object[])new Object[]{inputStream, "Cannot read file stream is empty, check readability and path."});
        try {
            Properties props = new Properties();
            props.load(inputStream);
            return this.parseConfiguration(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read property files");
        }
    }

    public FF4jConfiguration parseConfiguration(Properties props) {
        Util.assertNotNull((Object[])new Object[]{props, "Cannot parse null properties"});
        HashMap<String, String> mapProperties = new HashMap<String, String>();
        for (String name : props.stringPropertyNames()) {
            mapProperties.put(name, props.getProperty(name));
        }
        return this.parseConfiguration(mapProperties);
    }

    public FF4jConfiguration parseConfiguration(Map<String, String> mapProperties) {
        Util.assertNotNull((Object[])new Object[]{mapProperties, "Cannot parse null properties"});
        FF4jConfiguration ff4jConfig = new FF4jConfiguration();
        if (mapProperties.containsKey("ff4j.audit")) {
            ff4jConfig.setAudit(Boolean.valueOf(mapProperties.get("ff4j.audit")).booleanValue());
        }
        if (mapProperties.containsKey("ff4j.autocreate")) {
            ff4jConfig.setAutoCreate(Boolean.valueOf(mapProperties.get("ff4j.autocreate")).booleanValue());
        }
        ff4jConfig.getProperties().putAll(this.parseProperties("ff4j.properties", mapProperties));
        this.parseFeatures(ff4jConfig, mapProperties);
        return ff4jConfig;
    }

    private void assertKeyNotEmpty(Map<String, String> mapConfigProperties, String keyName) {
        String strValue = mapConfigProperties.get(keyName);
        if (null == strValue || "".equals(strValue)) {
            throw new IllegalArgumentException("Key [" + keyName + "] is required and value cannot be empty");
        }
    }

    private Map<String, Property<?>> parseProperties(String prefix, Map<String, String> mapConfigProperties) {
        HashMap result = new HashMap();
        int idx = 0;
        String currentPropertyKey = prefix + "." + idx;
        while (mapConfigProperties.containsKey(currentPropertyKey + "." + "name")) {
            String strFixedValues;
            String description;
            this.assertKeyNotEmpty(mapConfigProperties, currentPropertyKey + "." + "name");
            String name = mapConfigProperties.get(currentPropertyKey + "." + "name");
            this.assertKeyNotEmpty(mapConfigProperties, currentPropertyKey + "." + "value");
            String strValue = mapConfigProperties.get(currentPropertyKey + "." + "value");
            PropertyString ap = new PropertyString(name, strValue);
            String optionalType = mapConfigProperties.get(currentPropertyKey + "." + "type");
            if (null != optionalType) {
                optionalType = MappingUtil.mapPropertyType((String)optionalType);
                try {
                    Class<?> typeClass = Class.forName(optionalType);
                    if (!Property.class.isAssignableFrom(typeClass)) {
                        throw new IllegalArgumentException("Cannot create property <" + name + "> invalid type <" + optionalType + ">");
                    }
                    Constructor<?> constr = typeClass.getConstructor(String.class, String.class);
                    ap = (Property)constr.newInstance(name, strValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot instantiate '" + optionalType + "' check default constructor", e);
                }
            }
            if (null != (description = mapConfigProperties.get(currentPropertyKey + "." + "description"))) {
                ap.setDescription(description);
            }
            if (null != (strFixedValues = mapConfigProperties.get(currentPropertyKey + "." + "fixedValues")) && !"".equals(strFixedValues)) {
                Arrays.asList(strValue.split(",")).stream().map(String::trim).forEach(arg_0 -> ((Property)ap).add2FixedValueFromString(arg_0));
            }
            if (ap.getFixedValues() != null && !ap.getFixedValues().isEmpty() && !ap.getFixedValues().contains(ap.getValue())) {
                throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + ap.getValue() + "> expected one of " + ap.getFixedValues());
            }
            result.put(ap.getName(), (Property<?>)ap);
            currentPropertyKey = prefix + "." + ++idx;
        }
        return result;
    }

    private void parseFeatures(FF4jConfiguration ff4jConfig, Map<String, String> mapConf) {
        int idx = 0;
        String currentFeatureKey = "ff4j.features." + idx;
        while (mapConf.containsKey(currentFeatureKey + "." + "uid")) {
            String strPermissions;
            String groupName;
            this.assertKeyNotEmpty(mapConf, currentFeatureKey + "." + "uid");
            Feature f = new Feature(mapConf.get(currentFeatureKey + "." + "uid"));
            this.assertKeyNotEmpty(mapConf, currentFeatureKey + "." + "enable");
            f.setEnable(Boolean.valueOf(mapConf.get(currentFeatureKey + "." + "enable")).booleanValue());
            String description = mapConf.get(currentFeatureKey + "." + "description");
            if (null != description && !"".equals(description)) {
                f.setDescription(description);
            }
            if (null != (groupName = mapConf.get(currentFeatureKey + "." + "groupName")) && !"".equals(groupName)) {
                f.setGroup(groupName);
            }
            if (null != (strPermissions = mapConf.get(currentFeatureKey + "." + "permissions")) && !"".equals(strPermissions)) {
                f.setPermissions(Arrays.asList(strPermissions.split(",")).stream().map(String::trim).collect(Collectors.toSet()));
            }
            f.setCustomProperties(this.parseProperties(currentFeatureKey + "." + "custom-properties", mapConf));
            String flipStrategyClass = mapConf.get(currentFeatureKey + "." + "flipstrategy" + "." + "class");
            if (null != flipStrategyClass && !"".equals(flipStrategyClass)) {
                FlippingStrategy flipStrategy = null;
                try {
                    Class<?> typeClass = Class.forName(flipStrategyClass);
                    if (!FlippingStrategy.class.isAssignableFrom(typeClass)) {
                        throw new IllegalArgumentException("Cannot create flipstrategy <" + flipStrategyClass + "> invalid type");
                    }
                    flipStrategy = (FlippingStrategy)typeClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse flipStrategy for feature '" + f.getUid() + "' -> check key [" + currentFeatureKey + "." + "flipstrategy" + "." + "class" + "]", e);
                }
                int idxParam = 0;
                String currentParamKey = currentFeatureKey + "." + "flipstrategy" + "." + "param" + "." + idxParam;
                HashMap<String, String> params = new HashMap<String, String>();
                while (mapConf.containsKey(currentParamKey + "." + "name")) {
                    this.assertKeyNotEmpty(mapConf, currentParamKey + "." + "name");
                    this.assertKeyNotEmpty(mapConf, currentParamKey + "." + "value");
                    params.put(mapConf.get(currentParamKey + "." + "name"), mapConf.get(currentParamKey + "." + "value"));
                    currentParamKey = currentFeatureKey + "." + "flipstrategy" + "." + "param" + "." + ++idxParam;
                }
                flipStrategy.init(f.getUid(), params);
                f.setFlippingStrategy(flipStrategy);
            }
            ff4jConfig.getFeatures().put(f.getUid(), f);
            currentFeatureKey = "ff4j.features." + ++idx;
        }
    }
}

