/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.parser.yaml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ff4j.conf.FF4jConfiguration;
import org.ff4j.conf.FF4jConfigurationParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyString;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlParser
implements FF4jConfigurationParser<FF4jConfiguration> {
    private Yaml safeYaml = new Yaml((BaseConstructor)new SafeConstructor());

    public InputStream export(FF4jConfiguration ff4jConfig) {
        Util.assertNotNull((Object[])new Object[]{ff4jConfig});
        StringBuilder yamlFile = new StringBuilder().append(YamlParser.yamlKey("ff4j", 0, false)).append(YamlParser.yamlValue("autocreate", ff4jConfig.isAutoCreate(), 2, false)).append(YamlParser.yamlValue("audit", ff4jConfig.isAudit(), 2, false));
        if (null != ff4jConfig.getFeatures() && !ff4jConfig.getFeatures().isEmpty()) {
            yamlFile.append(YamlParser.yamlKey("features", 2, false));
            for (Feature f : ff4jConfig.getFeatures().values()) {
                yamlFile.append(YamlParser.yamlValue("uid", f.getUid(), 4, true));
                yamlFile.append(YamlParser.yamlValue("enable", f.isEnable(), 6, false));
                if (null != f.getDescription()) {
                    yamlFile.append(YamlParser.yamlValue("description", f.getDescription(), 6, false));
                }
                if (null != f.getGroup()) {
                    yamlFile.append(YamlParser.yamlValue("groupName", f.getGroup(), 6, false));
                }
                if (!f.getPermissions().isEmpty()) {
                    yamlFile.append(YamlParser.yamlValue("permissions", f.getPermissions(), 6, false));
                }
                if (null != f.getFlippingStrategy()) {
                    yamlFile.append(YamlParser.yamlKey("flipstrategy", 6, false));
                    yamlFile.append(YamlParser.yamlValue("class", f.getFlippingStrategy().getClass().getName(), 8, false));
                    yamlFile.append(YamlParser.yamlKey("param", 8, false));
                    for (Map.Entry entry : f.getFlippingStrategy().getInitParams().entrySet()) {
                        yamlFile.append(YamlParser.yamlValue("name", entry.getKey(), 10, true));
                        yamlFile.append(YamlParser.yamlValue("value", entry.getValue(), 12, false));
                    }
                }
                if (f.getCustomProperties().isEmpty()) continue;
                yamlFile.append(YamlParser.yamlKey("custom-properties", 6, false));
                if (f.getCustomProperties().isEmpty()) continue;
                f.getCustomProperties().values().stream().forEach(p -> yamlFile.append(YamlParser.yamlProperty(p, 8)));
            }
        }
        if (null != ff4jConfig.getProperties() && !ff4jConfig.getProperties().isEmpty()) {
            yamlFile.append(YamlParser.yamlKey("properties", 2, false));
            for (Property prop : ff4jConfig.getProperties().values()) {
                yamlFile.append(YamlParser.yamlProperty(prop, 4));
            }
        }
        String output = yamlFile.toString();
        System.out.println(output);
        return new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8));
    }

    public FF4jConfiguration parseConfigurationFile(InputStream inputStream) {
        Util.assertNotNull((Object[])new Object[]{inputStream, "Cannot read file stream is empty, check readability and path."});
        Map yamlConfigFile = (Map)this.safeYaml.load(inputStream);
        Map ff4jYamlMap = (Map)yamlConfigFile.get("ff4j");
        FF4jConfiguration ff4jConfig = new FF4jConfiguration();
        if (ff4jYamlMap != null) {
            if (ff4jYamlMap.containsKey("audit")) {
                ff4jConfig.setAudit(Boolean.valueOf(ff4jYamlMap.get("audit").toString()).booleanValue());
            }
            if (ff4jYamlMap.containsKey("autocreate")) {
                ff4jConfig.setAutoCreate(Boolean.valueOf(ff4jYamlMap.get("autocreate").toString()).booleanValue());
            }
            ff4jConfig.getProperties().putAll(this.parseProperties((List)ff4jYamlMap.get("properties")));
            this.parseFeatures(ff4jConfig, (List)ff4jYamlMap.get("features"));
        }
        return ff4jConfig;
    }

    private Map<String, Property<?>> parseProperties(List<Map<String, Object>> properties) {
        HashMap result = new HashMap();
        if (null != properties) {
            properties.forEach(property -> {
                List fixedValues;
                String description;
                String name = (String)property.get("name");
                if (null == name) {
                    throw new IllegalArgumentException("Invalid YAML File: 'name' is expected for properties");
                }
                Object objValue = property.get("value");
                if (null == objValue) {
                    throw new IllegalArgumentException("Invalid YAML File: 'value' is expected for properties");
                }
                String strValue = String.valueOf(objValue);
                if (objValue instanceof Date) {
                    strValue = SIMPLE_DATE_FORMAT.format((Date)objValue);
                }
                PropertyString ap = new PropertyString(name, strValue);
                String optionalType = (String)property.get("type");
                if (null != optionalType) {
                    optionalType = MappingUtil.mapPropertyType((String)optionalType);
                    try {
                        Class<?> typeClass = Class.forName(optionalType);
                        if (!Property.class.isAssignableFrom(typeClass)) {
                            throw new IllegalArgumentException("Cannot create property <" + name + "> invalid type <" + optionalType + ">");
                        }
                        Constructor<?> constr = typeClass.getConstructor(String.class, String.class);
                        ap = (Property)constr.newInstance(name, strValue);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot instantiate '" + optionalType + "' check default constructor", e);
                    }
                }
                if (null != (description = (String)property.get("description"))) {
                    ap.setDescription(description);
                }
                if (null != (fixedValues = (List)property.get("fixedValues")) && fixedValues.size() > 0) {
                    fixedValues.stream().map(Object::toString).forEach(arg_0 -> ((Property)ap).add2FixedValueFromString(arg_0));
                }
                if (ap.getFixedValues() != null && !ap.getFixedValues().isEmpty() && !ap.getFixedValues().contains(ap.getValue())) {
                    throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + ap.getValue() + "> expected one of " + ap.getFixedValues());
                }
                result.put(ap.getName(), (Property<?>)ap);
            });
        }
        return result;
    }

    private void parseFeatures(FF4jConfiguration ff4jConfig, List<Map<String, Object>> features) {
        if (null != features) {
            features.forEach(feature -> {
                List customProperties;
                Map mapFlipStrategy;
                List customPermissons;
                String groupName;
                String description;
                String name = (String)feature.get("uid");
                if (null == name) {
                    throw new IllegalArgumentException("Invalid YAML File: 'uid' is expected for feature");
                }
                Feature f = new Feature(name);
                Boolean enabled = (Boolean)feature.get("enable");
                if (null != enabled) {
                    f.setEnable(enabled.booleanValue());
                }
                if (null != (description = (String)feature.get("description"))) {
                    f.setDescription(description);
                }
                if (null != (groupName = (String)feature.get("groupName"))) {
                    f.setGroup(groupName);
                }
                if ((customPermissons = (List)feature.get("permissions")) != null) {
                    f.setPermissions(new HashSet(customPermissons));
                }
                if (null != (mapFlipStrategy = (Map)feature.get("flipstrategy"))) {
                    f.setFlippingStrategy(this.parseFlipStrategy(f, mapFlipStrategy));
                }
                if ((customProperties = (List)feature.get("custom-properties")) != null) {
                    f.setCustomProperties(this.parseProperties(customProperties));
                }
                ff4jConfig.getFeatures().put(f.getUid(), f);
            });
        }
    }

    private FlippingStrategy parseFlipStrategy(Feature feature, Map<String, Object> toggleStrategy) {
        try {
            String clazzName = (String)toggleStrategy.get("class");
            Class<?> typeClass = Class.forName(clazzName);
            if (!FlippingStrategy.class.isAssignableFrom(typeClass)) {
                throw new IllegalArgumentException("Cannot create flipstrategy <" + clazzName + "> invalid type");
            }
            FlippingStrategy flipStrategy = (FlippingStrategy)typeClass.newInstance();
            List mapYamlParam = (List)toggleStrategy.get("param");
            HashMap<String, String> params = new HashMap<String, String>();
            for (Map currentParam : mapYamlParam) {
                params.put(currentParam.get("name").toString(), currentParam.get("value").toString());
            }
            flipStrategy.init(feature.getUid(), params);
            return flipStrategy;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occurs during flipstrategy parsing TAG" + feature.getUid(), e);
        }
    }

    private static final <T> String yamlProperty(Property<T> p, int offset) {
        StringBuilder yamlProp = new StringBuilder();
        yamlProp.append(YamlParser.yamlValue("name", p.getName(), offset, true));
        yamlProp.append(YamlParser.yamlValue("type", p.getClass().getCanonicalName(), offset + 2, false));
        yamlProp.append(YamlParser.yamlValue("value", p.asString(), offset + 2, false));
        if (null != p.getFixedValues() && !p.getFixedValues().isEmpty()) {
            yamlProp.append(YamlParser.yamlValue("fixedValues", p.getFixedValues(), offset + 2, false));
        }
        return yamlProp.toString();
    }

    private static final String yamlKey(String key, int offset, boolean isList) {
        return new String(new char[offset]).replace('\u0000', ' ') + (isList ? "- " : "") + key + ": " + "\n";
    }

    private static final String yamlValue(String key, Object value, int offset, boolean isList) {
        return new String(new char[offset]).replace('\u0000', ' ') + (isList ? "- " : "") + key + ": " + value + "\n";
    }
}

