/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.security;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ff4j.security.AbstractAuthorizationManager;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityAuthorisationManager
extends AbstractAuthorizationManager {
    public Set<String> getCurrentUserPermissions() {
        LinkedHashSet<String> listOfRoles = new LinkedHashSet<String>();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!(auth instanceof AnonymousAuthenticationToken)) {
            for (GrantedAuthority grantedAuthority : auth.getAuthorities()) {
                listOfRoles.add(grantedAuthority.getAuthority());
            }
        }
        return listOfRoles;
    }

    public Set<String> listAllPermissions() {
        return this.getCurrentUserPermissions();
    }

    public String getCurrentUserName() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (null == auth || auth instanceof AnonymousAuthenticationToken) {
            return "anonymous";
        }
        return auth.getName();
    }
}

