/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.autoconfigure.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@AutoConfiguration
@ConditionalOnClass(value={FF4j.class})
@ComponentScan(value={"org.ff4j.spring.rest.api", "org.ff4j.services", "org.ff4j.aop", "org.ff4j.spring"})
@ConfigurationPropertiesScan
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/ff4j/spring/boot/autoconfigure/common/FF4JConfiguration;", "", "()V", "isAuditEnabled", "", "()Z", "setAuditEnabled", "(Z)V", "log", "Lorg/slf4j/Logger;", "getFF4J", "Lorg/ff4j/FF4j;", "ff4j-spring-boot-autoconfigure-common"})
public class FF4JConfiguration {
    @NotNull
    private final Logger log;
    @Value(value="${ff4j.audit.enabled:false}")
    private boolean isAuditEnabled;

    public FF4JConfiguration() {
        Logger logger = LoggerFactory.getLogger(FF4JConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    public boolean isAuditEnabled() {
        return this.isAuditEnabled;
    }

    public void setAuditEnabled(boolean bl) {
        this.isAuditEnabled = bl;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FF4j getFF4J() {
        this.log.info("Initializing FF4J");
        FF4j ff4j = new FF4j();
        this.log.info("FF4J isAuditEnabled: {}", (Object)this.isAuditEnabled());
        ff4j.audit(this.isAuditEnabled());
        return ff4j;
    }
}

