/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.autoconfigure;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.spring.boot.autoconfigure.FF4JConfigurationProperties;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.SpringDocConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@OpenAPIDefinition(info=@Info(title="FF4J (ff4j.org) WebAPI", description="Administer and operate all tasks on your features through this api.", termsOfService="http://www.ff4j.org/terms-of-service", contact=@Contact(name="Paul Williams", url="paul-williams.me", email="paul58914080@gmail.com"), license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0.html"), version="1.8"))
@ConditionalOnClass(value={SpringDocConfiguration.class})
@ConditionalOnWebApplication
@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/ff4j/spring/boot/autoconfigure/FF4JOpenApiConfiguration;", "", "config", "Lorg/ff4j/spring/boot/autoconfigure/FF4JConfigurationProperties;", "(Lorg/ff4j/spring/boot/autoconfigure/FF4JConfigurationProperties;)V", "groupApiEnabled", "Lorg/springdoc/core/GroupedOpenApi;", "ff4j-spring-boot-autoconfigure"})
public class FF4JOpenApiConfiguration {
    @NotNull
    private final FF4JConfigurationProperties config;

    public FF4JOpenApiConfiguration(@NotNull FF4JConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Bean
    @NotNull
    public GroupedOpenApi groupApiEnabled() {
        GroupedOpenApi groupedOpenApi;
        if (this.config.getApi().getSpringDoc().getEnabled()) {
            String[] stringArray = new String[]{this.config.getApi().getContextPath() + "/**"};
            GroupedOpenApi groupedOpenApi2 = GroupedOpenApi.builder().group(this.config.getApi().getSpringDoc().getGroup()).pathsToMatch(stringArray).build();
            groupedOpenApi = groupedOpenApi2;
            Intrinsics.checkNotNullExpressionValue((Object)groupedOpenApi2, (String)"builder().group(config.a\u2026contextPath}/**\").build()");
        } else {
            String[] stringArray = new String[]{this.config.getApi().getContextPath() + "/**"};
            GroupedOpenApi groupedOpenApi3 = GroupedOpenApi.builder().group(this.config.getApi().getSpringDoc().getGroup()).pathsToExclude(stringArray).build();
            groupedOpenApi = groupedOpenApi3;
            Intrinsics.checkNotNullExpressionValue((Object)groupedOpenApi3, (String)"builder().group(config.a\u2026contextPath}/**\").build()");
        }
        return groupedOpenApi;
    }
}

