/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.exceptions;

import org.ff4j.exception.InvalidPropertyTypeException;
import org.ff4j.services.exceptions.AuthorizationNotExistsException;
import org.ff4j.services.exceptions.FeatureIdBlankException;
import org.ff4j.services.exceptions.FeatureIdNotMatchException;
import org.ff4j.services.exceptions.FeatureNotFoundException;
import org.ff4j.services.exceptions.FeatureStoreNotCached;
import org.ff4j.services.exceptions.FlippingStrategyBadRequestException;
import org.ff4j.services.exceptions.GroupExistsException;
import org.ff4j.services.exceptions.GroupNotExistsException;
import org.ff4j.services.exceptions.PropertiesBadRequestException;
import org.ff4j.services.exceptions.PropertyNameBlankException;
import org.ff4j.services.exceptions.PropertyNameNotMatchException;
import org.ff4j.services.exceptions.PropertyNotFoundException;
import org.ff4j.services.exceptions.PropertyStoreNotCached;
import org.ff4j.services.exceptions.RoleExistsException;
import org.ff4j.services.exceptions.RoleNotExistsException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"org.ff4j.spring.boot.web.api.resources"})
public class FF4jExceptionHandler {
    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="bad request")
    public void badRequestHandler() {
    }

    @ExceptionHandler(value={FeatureNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="feature not found")
    public void featureNotFoundException() {
    }

    @ExceptionHandler(value={FeatureIdBlankException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="feature uid cannot be blank")
    public void featureIdBlankException() {
    }

    @ExceptionHandler(value={FeatureIdNotMatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="feature uid did not match with the requested feature uid to be created or updated")
    public void featureIdNotMatchException() {
    }

    @ExceptionHandler(value={FlippingStrategyBadRequestException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="flipping strategy specified wrongly")
    public void flippingStrategyBadRequestException() {
    }

    @ExceptionHandler(value={PropertiesBadRequestException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="properties specified wrongly")
    public void propertiesBadRequestException() {
    }

    @ExceptionHandler(value={RoleExistsException.class})
    @ResponseStatus(value=HttpStatus.NOT_MODIFIED, reason="role already exists")
    public void roleExistsException() {
    }

    @ExceptionHandler(value={RoleNotExistsException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="role does not exist")
    public void roleNotExistsException() {
    }

    @ExceptionHandler(value={GroupExistsException.class})
    @ResponseStatus(value=HttpStatus.NOT_MODIFIED, reason="group already exists")
    public void groupExistsException() {
    }

    @ExceptionHandler(value={GroupNotExistsException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="group does not exist")
    public void groupNotExistsException() {
    }

    @ExceptionHandler(value={FeatureStoreNotCached.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="feature store is not cached")
    public void featureStoreNotCached() {
    }

    @ExceptionHandler(value={AuthorizationNotExistsException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="no security has been defined")
    public void authorizationNotExistsException() {
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="property not found")
    public void propertyNotFoundException() {
    }

    @ExceptionHandler(value={InvalidPropertyTypeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="bad request")
    public void propertyValueInvalidException() {
    }

    @ExceptionHandler(value={PropertyNameBlankException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="property name cannot be blank")
    public void propertyNameBlankException() {
    }

    @ExceptionHandler(value={PropertyNameNotMatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="property name did not match with the requested property name to be created or updated")
    public void propertyNameNotMatchException() {
    }

    @ExceptionHandler(value={PropertyStoreNotCached.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="property store is not cached")
    public void propertyStoreNotCached() {
    }
}

