/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import org.ff4j.services.FF4jServices;
import org.ff4j.services.domain.AuthorizationsManagerApiBean;
import org.ff4j.services.domain.FF4jStatusApiBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ff4j"})
public class FF4jResource {
    @Autowired
    private FF4jServices ff4JServices;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Gets <b>ff4j</b> status overview", notes="Gets information related to <b>Monitoring</b>, <b>Security</b>, <b>Cache</b> and <b>Store</b>")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, return status of ff4j instance", response=FF4jStatusApiBean.class)})
    public FF4jStatusApiBean getStatus() {
        return this.ff4JServices.getStatus();
    }

    @RequestMapping(value={"/security"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Gets <b>Security</b> information (permissions manager)", notes="Security is implemented through dedicated <b>AuthorizationsManager</b> but it's not mandatory")
    @ApiResponses(value={@ApiResponse(code=200, message="Status of current ff4j security bean", response=AuthorizationsManagerApiBean.class), @ApiResponse(code=404, message="no security has been defined")})
    public AuthorizationsManagerApiBean getSecurityInfo() {
        return this.ff4JServices.getSecurityInfo();
    }

    @RequestMapping(value={"/check/{uid}"}, method={RequestMethod.GET})
    @ApiOperation(value="<b>Simple check</b> feature toggle", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="If feature is flipped"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity<Boolean> check(@PathVariable(value="uid") String featureUID) {
        Boolean status = this.ff4JServices.check(featureUID);
        return new ResponseEntity((Object)status, HttpStatus.OK);
    }

    @RequestMapping(value={"/check/{uid}"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="<b>Advanced check</b> feature toggle (parametrized)", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="If feature is flipped"), @ApiResponse(code=400, message="Invalid parameter"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity<Boolean> check(@PathVariable(value="uid") String featureUID, @RequestParam MultiValueMap<String, String> formParams) {
        Map map = formParams.toSingleValueMap();
        Boolean status = this.ff4JServices.check(featureUID, map);
        return new ResponseEntity((Object)status, HttpStatus.OK);
    }
}

