/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.ff4j.services.FeatureServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.spring.boot.web.api.utils.FeatureWebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ff4j/store/features/{uid}"})
public class FeatureResource {
    @Autowired
    private FeatureServices featureServices;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public FeatureApiBean getFeatureByUID(@PathVariable(value="uid") String featureUID) {
        return this.featureServices.getFeature(featureUID);
    }

    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    @ApiOperation(value="Create or update a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Feature uid is blank (or) feature uid did not match with the requested feature uid to be created or updated"), @ApiResponse(code=201, message="Feature has been created"), @ApiResponse(code=202, message="Feature has been updated"), @ApiResponse(code=204, message="No content, no changes made to the feature")})
    public ResponseEntity<Boolean> createOrUpdateFeature(@PathVariable(value="uid") String featureUID, @RequestBody FeatureApiBean featureApiBean) {
        return FeatureWebUtils.getBooleanResponseEntityByHttpStatus(this.featureServices.createOrUpdateFeature(featureUID, featureApiBean));
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ApiOperation(value="Delete a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="No content, feature is deleted"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity<?> deleteFeature(@PathVariable(value="uid") String featureUID) {
        this.featureServices.deleteFeature(featureUID);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/enable"}, method={RequestMethod.POST})
    @ApiOperation(value="Enable a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Features has been enabled"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity<?> enableFeature(@PathVariable(value="uid") String featureUID) {
        this.featureServices.enableFeature(featureUID);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/disable"}, method={RequestMethod.POST})
    @ApiOperation(value="Disable a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Features has been disabled"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity disableFeature(@PathVariable(value="uid") String featureUID) {
        this.featureServices.disableFeature(featureUID);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/grantrole/{role}"}, method={RequestMethod.POST})
    @ApiOperation(value="Grant a permission to a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Permission has been granted"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=304, message="Role already exists, nothing to update")})
    public ResponseEntity grantRoleToFeature(@PathVariable(value="uid") String featureUID, @PathVariable(value="role") String role) {
        this.featureServices.grantRoleToFeature(featureUID, role);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/removerole/{role}"}, method={RequestMethod.POST})
    @ApiOperation(value="Remove a permission from a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Permission has been granted"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity removeRoleFromFeature(@PathVariable(value="uid") String featureUID, @PathVariable(value="role") String role) {
        this.featureServices.removeRoleFromFeature(featureUID, role);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/addGroup/{groupName}"}, method={RequestMethod.POST})
    @ApiOperation(value="Define the group of the feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Group has been defined"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=304, message="Group already exists, nothing to update")})
    public ResponseEntity addGroupToFeature(@PathVariable(value="uid") String featureUID, @PathVariable(value="groupName") String groupName) {
        this.featureServices.addGroupToFeature(featureUID, groupName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/removeGroup/{groupName}"}, method={RequestMethod.POST})
    @ApiOperation(value="Remove the group of the feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Group has been removed"), @ApiResponse(code=404, message="Feature not found")})
    public ResponseEntity removeGroupFromFeature(@PathVariable(value="uid") String featureUID, @PathVariable(value="groupName") String groupName) {
        this.featureServices.removeGroupFromFeature(featureUID, groupName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }
}

