/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import org.ff4j.services.FeatureStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ff4j/store"})
public class FeatureStoreResource {
    @Autowired
    private FeatureStoreServices featureStoreService;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Displays information regarding the <b>FeaturesStore</b>", response=FeatureStoreApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="status of current feature store", response=FeatureStoreApiBean.class)})
    public FeatureStoreApiBean getFeatureStore() {
        return this.featureStoreService.getFeatureStore();
    }

    @RequestMapping(value={"/features"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Displays all the <b>Features</b>", response=FeatureApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="get all features")})
    public Collection<FeatureApiBean> getAllFeatures() {
        return this.featureStoreService.getAllFeatures();
    }

    @RequestMapping(value={"/groups"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Display information regarding <b>Groups</b>", response=GroupDescApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Groups resource", response=GroupDescApiBean.class)})
    public Collection<GroupDescApiBean> getAllGroups() {
        return this.featureStoreService.getAllGroups();
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete all <b>Features</b> in store")
    @ApiResponses(value={@ApiResponse(code=204, message="all feature have been deleted")})
    public ResponseEntity deleteAllFeatures() {
        this.featureStoreService.deleteAllFeatures();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/cache"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Display information related to <b>Cache</b>")
    @ApiResponses(value={@ApiResponse(code=200, message="Gets the cached features", response=CacheApiBean.class), @ApiResponse(code=404, message="feature store is not cached")})
    public CacheApiBean getFeaturesFromCache() {
        return this.featureStoreService.getFeaturesFromCache();
    }

    @RequestMapping(value={"//clearCache"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Clear cache", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="cache is cleared"), @ApiResponse(code=404, message="feature store is not cached")})
    public ResponseEntity clearCachedFeatureStore() {
        this.featureStoreService.clearCachedFeatureStore();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

