/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import org.ff4j.services.GroupServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ff4j/store/groups/{groupName}"})
public class GroupResource {
    @Autowired
    private GroupServices groupServices;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get all the features belonging to the group", response=FeatureApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="features belonging to the group"), @ApiResponse(code=404, message="Group not found")})
    public Collection<FeatureApiBean> getFeaturesByGroup(@PathVariable(value="groupName") String groupName) {
        return this.groupServices.getFeaturesByGroup(groupName);
    }

    @RequestMapping(value={"/enable"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Enable a group", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Group has been enabled"), @ApiResponse(code=404, message="Group not found")})
    public void enableGroup(@PathVariable(value="groupName") String groupName) {
        this.groupServices.enableGroup(groupName);
    }

    @RequestMapping(value={"/disable"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Disable a group", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Group has been disabled"), @ApiResponse(code=404, message="Group not found")})
    public void disableGroup(@PathVariable(value="groupName") String groupName) {
        this.groupServices.disableGroup(groupName);
    }
}

