/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.ff4j.services.PropertyServices;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.spring.boot.web.api.utils.FeatureWebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ff4j/propertyStore/properties/{name}"})
public class PropertyResource {
    @Autowired
    private PropertyServices propertyServices;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Read information about a property", response=PropertyApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Information about property"), @ApiResponse(code=404, message="Property not found")})
    public PropertyApiBean getProperty(@PathVariable(value="name") String propertyName) {
        return this.propertyServices.getProperty(propertyName);
    }

    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @ApiOperation(value="Create or update a property", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Property name is blank (or) property name did not match with the requested property name to be created or updated"), @ApiResponse(code=201, message="Property has been created"), @ApiResponse(code=202, message="Property has been updated"), @ApiResponse(code=204, message="No content, no changes made to the feature")})
    public ResponseEntity createOrUpdateProperty(@PathVariable(value="name") String propertyName, @RequestBody PropertyApiBean propertyApiBean) {
        return FeatureWebUtils.getBooleanResponseEntityByHttpStatus(this.propertyServices.createOrUpdateProperty(propertyName, propertyApiBean));
    }

    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiOperation(value="Delete a property", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="No content, property is deleted"), @ApiResponse(code=404, message="Property not found")})
    public ResponseEntity deleteProperty(@PathVariable(value="name") String propertyName) {
        this.propertyServices.deleteProperty(propertyName);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/update/{value}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Update value of a property", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Property has been updated"), @ApiResponse(code=404, message="Property not found"), @ApiResponse(code=400, message="Invalid new value")})
    public ResponseEntity updatePropertyName(@PathVariable(value="name") String propertyName, @PathVariable(value="value") String newPropertyName) {
        this.propertyServices.updatePropertyName(propertyName, newPropertyName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }
}

