/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.ff4j.services.PropertyStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.domain.PropertyStoreApiBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ff4j/propertyStore"})
public class PropertyStoreResource {
    @Autowired
    private PropertyStoreServices propertyStoreServices;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Display information regarding <b>Properties Store</b>", response=PropertyStoreApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="status of current properties store")})
    public PropertyStoreApiBean getPropertyStore() {
        return this.propertyStoreServices.getPropertyStore();
    }

    @RequestMapping(value={"/properties"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Display all the <b>Properties</b>", response=PropertyApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="get all Properties")})
    public List<PropertyApiBean> getAllProperties() {
        return this.propertyStoreServices.getAllProperties();
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete all <b>Properties</b> in store")
    @ApiResponses(value={@ApiResponse(code=204, message="all properties have been deleted", response=ResponseEntity.class)})
    public ResponseEntity deleteAllProperties() {
        this.propertyStoreServices.deleteAllProperties();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/cache"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Display information related to <b>Cache</b>")
    @ApiResponses(value={@ApiResponse(code=200, message="Gets the cached properties", response=CacheApiBean.class), @ApiResponse(code=404, message="property store is not cached")})
    public CacheApiBean getPropertiesFromCache() {
        return this.propertyStoreServices.getPropertiesFromCache();
    }

    @RequestMapping(value={"/clearCache"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Clear cache", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="cache is cleared"), @ApiResponse(code=404, message="property store is not cached")})
    public ResponseEntity clearCachedPropertyStore() {
        this.propertyStoreServices.clearCachedPropertyStore();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

