/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FeatureServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.spring.boot.web.api.utils.FeatureWebUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Feature", description="The API for feature related operations")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/store/features/{uid}"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0017J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\u0014\u001a\u00020\u00102\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u000bH\u0017J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/FeatureResource;", "", "featureServices", "Lorg/ff4j/services/FeatureServices;", "(Lorg/ff4j/services/FeatureServices;)V", "getFeatureServices", "()Lorg/ff4j/services/FeatureServices;", "addGroupToFeature", "Lorg/springframework/http/ResponseEntity;", "Ljava/lang/Void;", "featureUID", "", "groupName", "createOrUpdateFeature", "", "featureApiBean", "Lorg/ff4j/services/domain/FeatureApiBean;", "deleteFeature", "disableFeature", "enableFeature", "getFeatureByUID", "grantRoleToFeature", "role", "removeGroupFromFeature", "removeRoleFromFeature", "ff4j-spring-boot-web-api"})
public class FeatureResource {
    @NotNull
    private final FeatureServices featureServices;

    public FeatureResource(@Autowired @NotNull FeatureServices featureServices) {
        Intrinsics.checkNotNullParameter((Object)featureServices, (String)"featureServices");
        this.featureServices = featureServices;
    }

    @NotNull
    public FeatureServices getFeatureServices() {
        return this.featureServices;
    }

    @Operation(tags={"Feature"}, summary="Get feature by uid", description="Get feature by uid")
    @ApiResponses(value={@ApiResponse(description="OK", responseCode="200", content={@Content(schema=@Schema(implementation=FeatureApiBean.class))}), @ApiResponse(description="Feature not found", responseCode="404")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public FeatureApiBean getFeatureByUID(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        return this.getFeatureServices().getFeature(featureUID);
    }

    @Operation(tags={"Feature"}, summary="Create or update a feature")
    @ApiResponses(value={@ApiResponse(description="Feature uid is blank (or) feature uid did not match with the requested feature uid to be created or updated", responseCode="400"), @ApiResponse(description="Feature has been created", responseCode="201", content={@Content(schema=@Schema(implementation=boolean.class))}), @ApiResponse(description="Feature has been updated", responseCode="204", content={@Content(schema=@Schema(implementation=boolean.class))})})
    @PutMapping(consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<Boolean> createOrUpdateFeature(@PathVariable(value="uid") @NotNull String featureUID, @RequestBody @NotNull FeatureApiBean featureApiBean) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)featureApiBean, (String)"featureApiBean");
        return FeatureWebUtils.INSTANCE.getBooleanResponseEntityByHttpStatus(this.getFeatureServices().createOrUpdateFeature(featureUID, featureApiBean));
    }

    @Operation(tags={"Feature"}, summary="Delete a feature")
    @ApiResponses(value={@ApiResponse(description="No content, feature is deleted", responseCode="204"), @ApiResponse(description="Feature not found", responseCode="404")})
    @DeleteMapping
    @NotNull
    public ResponseEntity<Void> deleteFeature(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureServices().deleteFeature(featureUID);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(tags={"Feature"}, summary="Enable a feature")
    @ApiResponses(value={@ApiResponse(description="Features has been enabled", responseCode="202"), @ApiResponse(description="Feature not found", responseCode="404")})
    @PostMapping(value={"/enable"})
    @NotNull
    public ResponseEntity<Void> enableFeature(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureServices().enableFeature(featureUID);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @Operation(tags={"Feature"}, summary="Disable a feature")
    @ApiResponses(value={@ApiResponse(description="Features has been disabled", responseCode="202"), @ApiResponse(description="Feature not found", responseCode="404")})
    @PostMapping(value={"/disable"})
    @NotNull
    public ResponseEntity<Void> disableFeature(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureServices().disableFeature(featureUID);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @Operation(tags={"Feature"}, summary="Grant a permission to a feature")
    @ApiResponses(value={@ApiResponse(description="Permission has been granted", responseCode="202"), @ApiResponse(description="Feature not found", responseCode="404"), @ApiResponse(description="Role already exists, nothing to update", responseCode="304")})
    @PostMapping(value={"/grantrole/{role}"})
    @NotNull
    public ResponseEntity<Void> grantRoleToFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="role") @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.getFeatureServices().grantRoleToFeature(featureUID, role);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @Operation(tags={"Feature"}, summary="Revoke a permission from a feature")
    @ApiResponses(value={@ApiResponse(description="Permission has been granted", responseCode="202"), @ApiResponse(description="Feature not found", responseCode="404")})
    @PostMapping(value={"/removerole/{role}"})
    @NotNull
    public ResponseEntity<Void> removeRoleFromFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="role") @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.getFeatureServices().removeRoleFromFeature(featureUID, role);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @Operation(tags={"Feature"}, summary="Define the group of the feature")
    @ApiResponses(value={@ApiResponse(description="Group has been defined", responseCode="202"), @ApiResponse(description="Feature not found", responseCode="404"), @ApiResponse(description="Group already exists, nothing to update", responseCode="304")})
    @PostMapping(value={"/addGroup/{groupName}"})
    @NotNull
    public ResponseEntity<Void> addGroupToFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFeatureServices().addGroupToFeature(featureUID, groupName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @Operation(tags={"Feature"}, summary="Remove the group of the feature")
    @ApiResponses(value={@ApiResponse(description="Group has been removed", responseCode="204"), @ApiResponse(description="Feature not found", responseCode="404")})
    @PostMapping(value={"/removeGroup/{groupName}"})
    @NotNull
    public ResponseEntity<Void> removeGroupFromFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFeatureServices().removeGroupFromFeature(featureUID, groupName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }
}

