/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.GroupServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Groups", description="The API for group related operations")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/store/groups/{groupName}"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/GroupResource;", "", "groupServices", "Lorg/ff4j/services/GroupServices;", "(Lorg/ff4j/services/GroupServices;)V", "getGroupServices", "()Lorg/ff4j/services/GroupServices;", "disableGroup", "", "groupName", "", "enableGroup", "getFeaturesByGroup", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "ff4j-spring-boot-web-api"})
public class GroupResource {
    @NotNull
    private final GroupServices groupServices;

    public GroupResource(@Autowired @NotNull GroupServices groupServices) {
        Intrinsics.checkNotNullParameter((Object)groupServices, (String)"groupServices");
        this.groupServices = groupServices;
    }

    @NotNull
    public GroupServices getGroupServices() {
        return this.groupServices;
    }

    @Operation(tags={"Groups"}, summary="Get all the features belonging to the group")
    @ApiResponses(value={@ApiResponse(description="features belonging to the group", responseCode="200", content={@Content(schema=@Schema(implementation=FeatureApiBean.class))}), @ApiResponse(description="Group not found", responseCode="404")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public Collection<FeatureApiBean> getFeaturesByGroup(@PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return this.getGroupServices().getFeaturesByGroup(groupName);
    }

    @Operation(tags={"Groups"}, summary="Enable a group")
    @ApiResponses(value={@ApiResponse(description="Group has been enabled", responseCode="200"), @ApiResponse(description="Group not found", responseCode="404")})
    @PostMapping(value={"/enable"}, produces={"application/json"})
    public void enableGroup(@PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getGroupServices().enableGroup(groupName);
    }

    @Operation(tags={"Groups"}, summary="Disable a group")
    @ApiResponses(value={@ApiResponse(description="Group has been disabled", responseCode="200"), @ApiResponse(description="Group not found", responseCode="404")})
    @PostMapping(value={"/disable"}, produces={"application/json"})
    public void disableGroup(@PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getGroupServices().disableGroup(groupName);
    }
}

