/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FeatureStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="FeatureStore", description="The API for accessing the store of all features")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/store"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/FeatureStoreResource;", "", "featureStoreService", "Lorg/ff4j/services/FeatureStoreServices;", "(Lorg/ff4j/services/FeatureStoreServices;)V", "getFeatureStoreService", "()Lorg/ff4j/services/FeatureStoreServices;", "clearCachedFeatureStore", "Lorg/springframework/http/ResponseEntity;", "Ljava/lang/Void;", "deleteAllFeatures", "getAllFeatures", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "getAllGroups", "Lorg/ff4j/services/domain/GroupDescApiBean;", "getFeatureStore", "Lorg/ff4j/services/domain/FeatureStoreApiBean;", "getFeaturesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "ff4j-spring-boot-web-api"})
public class FeatureStoreResource {
    @NotNull
    private final FeatureStoreServices featureStoreService;

    public FeatureStoreResource(@Autowired @NotNull FeatureStoreServices featureStoreService) {
        Intrinsics.checkNotNullParameter((Object)featureStoreService, (String)"featureStoreService");
        this.featureStoreService = featureStoreService;
    }

    @NotNull
    public FeatureStoreServices getFeatureStoreService() {
        return this.featureStoreService;
    }

    @Operation(tags={"FeatureStore"}, summary="Displays information regarding the FeaturesStore")
    @ApiResponses(value={@ApiResponse(description="OK", responseCode="200", content={@Content(schema=@Schema(implementation=FeatureApiBean.class))})})
    @GetMapping(produces={"application/json"})
    @NotNull
    public FeatureStoreApiBean getFeatureStore() {
        return this.getFeatureStoreService().getFeatureStore();
    }

    @Operation(tags={"FeatureStore"}, summary="Displays all the Features")
    @GetMapping(value={"/features"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(description="get all features", responseCode="200", content={@Content(schema=@Schema(implementation=FeatureApiBean.class))})})
    @NotNull
    public Collection<FeatureApiBean> getAllFeatures() {
        return this.getFeatureStoreService().getAllFeatures();
    }

    @Operation(tags={"FeatureStore"}, summary="Display information regarding Groups")
    @GetMapping(value={"/groups"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(description="Groups resource", responseCode="200", content={@Content(schema=@Schema(implementation=GroupDescApiBean.class))})})
    @NotNull
    public Collection<GroupDescApiBean> getAllGroups() {
        return this.getFeatureStoreService().getAllGroups();
    }

    @Operation(tags={"FeatureStore"}, summary="Display information related to Cache")
    @GetMapping(value={"/cache"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(description="Gets the cached features", responseCode="200", content={@Content(schema=@Schema(implementation=CacheApiBean.class))}), @ApiResponse(description="feature store is not cached", responseCode="404")})
    @NotNull
    public CacheApiBean getFeaturesFromCache() {
        return this.getFeatureStoreService().getFeaturesFromCache();
    }

    @Operation(tags={"FeatureStore"}, summary="Delete all Features in store")
    @DeleteMapping(value={"/clear"})
    @ApiResponses(value={@ApiResponse(description="all feature have been deleted", responseCode="204")})
    @NotNull
    public ResponseEntity<Void> deleteAllFeatures() {
        this.getFeatureStoreService().deleteAllFeatures();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(tags={"FeatureStore"}, summary="Clear cache")
    @DeleteMapping(value={"/clearCache"})
    @ApiResponses(value={@ApiResponse(description="Gcache is cleared", responseCode="204"), @ApiResponse(description="feature store is not cached", responseCode="404")})
    @NotNull
    public ResponseEntity<Void> clearCachedFeatureStore() {
        this.getFeatureStoreService().clearCachedFeatureStore();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

