/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.rest.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FF4jServices;
import org.ff4j.services.domain.AuthorizationsManagerApiBean;
import org.ff4j.services.domain.FF4jStatusApiBean;
import org.ff4j.services.exceptions.FeatureNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Tag(name="FF4J", description="The API for global status of FF4J")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J4\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0014\b\u0001\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eH\u0017JF\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u000f0\t0\b2\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0014\b\u0001\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eH\u0017J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\t0\bH\u0017J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\t0\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/ff4j/spring/rest/api/resources/FF4jResource;", "", "ff4JServices", "Lorg/ff4j/services/FF4jServices;", "(Lorg/ff4j/services/FF4jServices;)V", "getFf4JServices", "()Lorg/ff4j/services/FF4jServices;", "check", "Lorg/springframework/http/ResponseEntity;", "Lreactor/core/publisher/Mono;", "", "featureUID", "", "formParams", "Lorg/springframework/util/MultiValueMap;", "", "featureUIDs", "", "getSecurityInfo", "Lorg/ff4j/services/domain/AuthorizationsManagerApiBean;", "getStatus", "Lorg/ff4j/services/domain/FF4jStatusApiBean;", "ff4j-spring-rest-api"})
public class FF4jResource {
    @NotNull
    private final FF4jServices ff4JServices;

    public FF4jResource(@Autowired @NotNull FF4jServices ff4JServices) {
        Intrinsics.checkNotNullParameter((Object)ff4JServices, (String)"ff4JServices");
        this.ff4JServices = ff4JServices;
    }

    @NotNull
    public FF4jServices getFf4JServices() {
        return this.ff4JServices;
    }

    @Operation(tags={"FF4J"}, summary="Gets ff4j status overview", description="Gets information related to Monitoring, Security, Cache and Store")
    @ApiResponses(value={@ApiResponse(description="Success, return status of ff4j instance", responseCode="200", content={@Content(schema=@Schema(implementation=FF4jStatusApiBean.class))})})
    @GetMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<FF4jStatusApiBean>> getStatus() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getFf4JServices().getStatus());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FF4J"}, summary="Gets Security information (permissions manager)", description="Security is implemented through dedicated AuthorizationsManager but it's not mandatory")
    @ApiResponses(value={@ApiResponse(description="Status of current ff4j security bean", responseCode="200", content={@Content(schema=@Schema(implementation=AuthorizationsManagerApiBean.class))}), @ApiResponse(description="no security has been defined", responseCode="404")})
    @GetMapping(value={"/security"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<AuthorizationsManagerApiBean>> getSecurityInfo() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getFf4JServices().getSecurityInfo());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FF4J"}, summary="Simple check feature toggle")
    @ApiResponses(value={@ApiResponse(description="If feature is flipped", responseCode="200", content={@Content(schema=@Schema(implementation=boolean.class))}), @ApiResponse(description="Feature not found", responseCode="404")})
    @GetMapping(value={"/check/{uid}"})
    @NotNull
    public ResponseEntity<Mono<Boolean>> check(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Mono status = this.getFf4JServices().check(featureUID);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)status);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FF4J"}, summary="Advanced check feature toggle (parametrized)")
    @ApiResponses(value={@ApiResponse(description="If feature is flipped", responseCode="200", content={@Content(schema=@Schema(implementation=boolean.class))}), @ApiResponse(description="Invalid parameter", responseCode="400"), @ApiResponse(description="Feature not found", responseCode="404")})
    @PostMapping(value={"/check/{uid}"}, consumes={"application/x-www-form-urlencoded"})
    @NotNull
    public ResponseEntity<Mono<Boolean>> check(@PathVariable(value="uid") @NotNull String featureUID, @RequestParam @NotNull MultiValueMap<String, String> formParams) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter(formParams, (String)"formParams");
        Map map = formParams.toSingleValueMap();
        FF4jServices fF4jServices = this.getFf4JServices();
        Intrinsics.checkNotNull((Object)map);
        Mono status = fF4jServices.check(featureUID, map);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)status);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FF4J"}, summary="Check feature toggles")
    @ApiResponses(value={@ApiResponse(description="Map of featureUId/flipped", responseCode="200", content={@Content(schema=@Schema(implementation=Map.class))}), @ApiResponse(description="Invalid parameter", responseCode="400")})
    @PostMapping(value={"/check"})
    @NotNull
    public ResponseEntity<Mono<Map<String, Boolean>>> check(@RequestBody @NotNull Set<String> featureUIDs, @RequestParam @NotNull MultiValueMap<String, String> formParams) {
        Intrinsics.checkNotNullParameter(featureUIDs, (String)"featureUIDs");
        Intrinsics.checkNotNullParameter(formParams, (String)"formParams");
        HashMap<String, Boolean> featureUIDToEnableMap = new HashMap<String, Boolean>();
        for (String featureUID : featureUIDs) {
            try {
                FF4jServices fF4jServices = this.getFf4JServices();
                Map map = formParams.toSingleValueMap();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toSingleValueMap(...)");
                fF4jServices.check(featureUID, map).map(arg_0 -> FF4jResource.check$lambda$0((Function1)new Function1<Boolean, Unit>(featureUIDToEnableMap, featureUID){
                    final /* synthetic */ HashMap<String, Boolean> $featureUIDToEnableMap;
                    final /* synthetic */ String $featureUID;
                    {
                        this.$featureUIDToEnableMap = $featureUIDToEnableMap;
                        this.$featureUID = $featureUID;
                        super(1);
                    }

                    public final void invoke(Boolean it) {
                        Map map = this.$featureUIDToEnableMap;
                        Intrinsics.checkNotNull((Object)it);
                        map.put(this.$featureUID, it);
                    }
                }, arg_0)).subscribe();
            }
            catch (FeatureNotFoundException e) {
                ((Map)featureUIDToEnableMap).put(featureUID, false);
            }
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)Mono.just(featureUIDToEnableMap));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    private static final Unit check$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }
}

