/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.rest.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FeatureStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Tag(name="FeatureStore", description="The API for accessing the store of all features")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/store"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0017J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0017J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\bH\u0017J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\bH\u0017J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\t0\bH\u0017J\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\t0\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/ff4j/spring/rest/api/resources/FeatureStoreResource;", "", "featureStoreService", "Lorg/ff4j/services/FeatureStoreServices;", "(Lorg/ff4j/services/FeatureStoreServices;)V", "getFeatureStoreService", "()Lorg/ff4j/services/FeatureStoreServices;", "clearCachedFeatureStore", "Lorg/springframework/http/ResponseEntity;", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "deleteAllFeatures", "getAllFeatures", "Lreactor/core/publisher/Flux;", "Lorg/ff4j/services/domain/FeatureApiBean;", "getAllGroups", "Lorg/ff4j/services/domain/GroupDescApiBean;", "getFeatureStore", "Lorg/ff4j/services/domain/FeatureStoreApiBean;", "getFeaturesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "ff4j-spring-rest-api"})
public class FeatureStoreResource {
    @NotNull
    private final FeatureStoreServices featureStoreService;

    public FeatureStoreResource(@Autowired @NotNull FeatureStoreServices featureStoreService) {
        Intrinsics.checkNotNullParameter((Object)featureStoreService, (String)"featureStoreService");
        this.featureStoreService = featureStoreService;
    }

    @NotNull
    public FeatureStoreServices getFeatureStoreService() {
        return this.featureStoreService;
    }

    @Operation(tags={"FeatureStore"}, summary="Displays information regarding the FeaturesStore")
    @ApiResponses(value={@ApiResponse(description="OK", responseCode="200", content={@Content(schema=@Schema(implementation=FeatureApiBean.class))})})
    @GetMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<FeatureStoreApiBean>> getFeatureStore() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getFeatureStoreService().getFeatureStore());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FeatureStore"}, summary="Displays all the Features")
    @GetMapping(value={"/features"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(description="get all features", responseCode="200", content={@Content(schema=@Schema(implementation=FeatureApiBean.class))})})
    @NotNull
    public ResponseEntity<Flux<FeatureApiBean>> getAllFeatures() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getFeatureStoreService().getAllFeatures());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FeatureStore"}, summary="Display information regarding Groups")
    @GetMapping(value={"/groups"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(description="Groups resource", responseCode="200", content={@Content(schema=@Schema(implementation=GroupDescApiBean.class))})})
    @NotNull
    public ResponseEntity<Flux<GroupDescApiBean>> getAllGroups() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getFeatureStoreService().getAllGroups());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FeatureStore"}, summary="Display information related to Cache")
    @GetMapping(value={"/cache"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(description="Gets the cached features", responseCode="200", content={@Content(schema=@Schema(implementation=CacheApiBean.class))}), @ApiResponse(description="feature store is not cached", responseCode="404")})
    @NotNull
    public ResponseEntity<Mono<CacheApiBean>> getFeaturesFromCache() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getFeatureStoreService().getFeaturesFromCache());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"FeatureStore"}, summary="Delete all Features in store")
    @DeleteMapping(value={"/clear"})
    @ApiResponses(value={@ApiResponse(description="all feature have been deleted", responseCode="204")})
    @NotNull
    public ResponseEntity<Mono<Void>> deleteAllFeatures() {
        this.getFeatureStoreService().deleteAllFeatures();
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NO_CONTENT)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }

    @Operation(tags={"FeatureStore"}, summary="Clear cache")
    @DeleteMapping(value={"/clearCache"})
    @ApiResponses(value={@ApiResponse(description="Gcache is cleared", responseCode="204"), @ApiResponse(description="feature store is not cached", responseCode="404")})
    @NotNull
    public ResponseEntity<Mono<Void>> clearCachedFeatureStore() {
        this.getFeatureStoreService().clearCachedFeatureStore();
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NO_CONTENT)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }
}

