/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.rest.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.PropertyServices;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.model.FeatureActions;
import org.ff4j.spring.rest.api.utils.FeatureWebUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Tag(name="Property", description="The API for property related operations")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/propertyStore/properties/{name}"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u001e\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u001e\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J(\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/ff4j/spring/rest/api/resources/PropertyResource;", "", "propertyServices", "Lorg/ff4j/services/PropertyServices;", "(Lorg/ff4j/services/PropertyServices;)V", "getPropertyServices", "()Lorg/ff4j/services/PropertyServices;", "createOrUpdateProperty", "Lorg/springframework/http/ResponseEntity;", "Lreactor/core/publisher/Mono;", "", "propertyName", "", "propertyApiBean", "Lorg/ff4j/services/domain/PropertyApiBean;", "deleteProperty", "Ljava/lang/Void;", "getProperty", "updatePropertyName", "newPropertyName", "ff4j-spring-rest-api"})
public class PropertyResource {
    @NotNull
    private final PropertyServices propertyServices;

    public PropertyResource(@Autowired @NotNull PropertyServices propertyServices) {
        Intrinsics.checkNotNullParameter((Object)propertyServices, (String)"propertyServices");
        this.propertyServices = propertyServices;
    }

    @NotNull
    public PropertyServices getPropertyServices() {
        return this.propertyServices;
    }

    @Operation(tags={"Property"}, summary="Read information about a property")
    @ApiResponses(value={@ApiResponse(description="Information about property", responseCode="200", content={@Content(schema=@Schema(implementation=PropertyApiBean.class))}), @ApiResponse(description="Property not found", responseCode="404")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<PropertyApiBean>> getProperty(@PathVariable(value="name") @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getPropertyServices().getProperty(propertyName));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"Property"}, summary="Create or update a property")
    @ApiResponses(value={@ApiResponse(description="Property has been created", responseCode="201"), @ApiResponse(description="Property has been updated", responseCode="202"), @ApiResponse(description="Property name is blank (or) property name did not match with the requested property name to be created or updated", responseCode="400")})
    @PutMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<Boolean>> createOrUpdateProperty(@PathVariable(value="name") @NotNull String propertyName, @RequestBody @NotNull PropertyApiBean propertyApiBean) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyApiBean, (String)"propertyApiBean");
        return FeatureWebUtils.INSTANCE.getBooleanResponseEntityByHttpStatus((Mono<FeatureActions>)this.getPropertyServices().createOrUpdateProperty(propertyName, propertyApiBean));
    }

    @Operation(tags={"Property"}, summary="Delete a property")
    @ApiResponses(value={@ApiResponse(description="No content, property is deleted", responseCode="204"), @ApiResponse(description="Property not found", responseCode="404")})
    @DeleteMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<Void>> deleteProperty(@PathVariable(value="name") @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.getPropertyServices().deleteProperty(propertyName);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NO_CONTENT)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }

    @Operation(tags={"Property"}, summary="Update value of a property")
    @ApiResponses(value={@ApiResponse(description="Property has been updated", responseCode="202"), @ApiResponse(description="Property not found", responseCode="404"), @ApiResponse(description="Invalid new value", responseCode="400")})
    @PostMapping(value={"/update/{value}"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<Void>> updatePropertyName(@PathVariable(value="name") @NotNull String propertyName, @PathVariable(value="value") @NotNull String newPropertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)newPropertyName, (String)"newPropertyName");
        this.getPropertyServices().updatePropertyName(propertyName, newPropertyName);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.ACCEPTED)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }
}

