/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.rest.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.PropertyStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.domain.PropertyStoreApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Tag(name="PropertyStore", description="The API for accessing the store for all properties")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/propertyStore"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0017J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0017J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\bH\u0017J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\bH\u0017J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\t0\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/ff4j/spring/rest/api/resources/PropertyStoreResource;", "", "propertyStoreServices", "Lorg/ff4j/services/PropertyStoreServices;", "(Lorg/ff4j/services/PropertyStoreServices;)V", "getPropertyStoreServices", "()Lorg/ff4j/services/PropertyStoreServices;", "clearCachedPropertyStore", "Lorg/springframework/http/ResponseEntity;", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "deleteAllProperties", "getAllProperties", "Lreactor/core/publisher/Flux;", "Lorg/ff4j/services/domain/PropertyApiBean;", "getPropertiesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "getPropertyStore", "Lorg/ff4j/services/domain/PropertyStoreApiBean;", "ff4j-spring-rest-api"})
public class PropertyStoreResource {
    @NotNull
    private final PropertyStoreServices propertyStoreServices;

    public PropertyStoreResource(@Autowired @NotNull PropertyStoreServices propertyStoreServices) {
        Intrinsics.checkNotNullParameter((Object)propertyStoreServices, (String)"propertyStoreServices");
        this.propertyStoreServices = propertyStoreServices;
    }

    @NotNull
    public PropertyStoreServices getPropertyStoreServices() {
        return this.propertyStoreServices;
    }

    @Operation(tags={"PropertyStore"}, summary="Display information regarding Properties Store")
    @ApiResponses(value={@ApiResponse(description="status of current properties store", responseCode="200", content={@Content(schema=@Schema(implementation=PropertyStoreApiBean.class))})})
    @GetMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<PropertyStoreApiBean>> getPropertyStore() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getPropertyStoreServices().getPropertyStore());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"PropertyStore"}, summary="Display all the Properties")
    @ApiResponses(value={@ApiResponse(description="get all Properties", responseCode="200", content={@Content(schema=@Schema(implementation=PropertyApiBean.class))})})
    @GetMapping(value={"/properties"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<Flux<PropertyApiBean>> getAllProperties() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getPropertyStoreServices().getAllProperties());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"PropertyStore"}, summary="Display information related to Cache")
    @ApiResponses(value={@ApiResponse(description="Gets the cached properties", responseCode="200", content={@Content(schema=@Schema(implementation=CacheApiBean.class))}), @ApiResponse(description="property store is not cached", responseCode="404")})
    @GetMapping(value={"/cache"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<CacheApiBean>> getPropertiesFromCache() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getPropertyStoreServices().getPropertiesFromCache());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(tags={"PropertyStore"}, summary="Delete all Properties in store")
    @ApiResponses(value={@ApiResponse(description="all properties have been deleted", responseCode="204")})
    @DeleteMapping(value={"/clear"})
    @NotNull
    public ResponseEntity<Mono<Void>> deleteAllProperties() {
        this.getPropertyStoreServices().deleteAllProperties();
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NO_CONTENT)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }

    @Operation(tags={"PropertyStore"}, summary="Clear cache")
    @ApiResponses(value={@ApiResponse(description="cache is cleared", responseCode="204"), @ApiResponse(description="property store is not cached", responseCode="404")})
    @DeleteMapping(value={"/clearCache"})
    @NotNull
    public ResponseEntity<Mono<Void>> clearCachedPropertyStore() {
        this.getPropertyStoreServices().clearCachedPropertyStore();
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NO_CONTENT)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }
}

