/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.services.PropertyStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.domain.PropertyStoreApiBean;
import org.ff4j.services.exceptions.PropertyStoreNotCached;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/ff4j/services/PropertyStoreServices;", "", "ff4j", "Lorg/ff4j/FF4j;", "(Lorg/ff4j/FF4j;)V", "getFf4j", "()Lorg/ff4j/FF4j;", "clearCachedPropertyStore", "", "deleteAllProperties", "getAllProperties", "", "Lorg/ff4j/services/domain/PropertyApiBean;", "getPropertiesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "getPropertyStore", "Lorg/ff4j/services/domain/PropertyStoreApiBean;", "ff4j-spring-services"})
public class PropertyStoreServices {
    @NotNull
    private final FF4j ff4j;

    @NotNull
    public PropertyStoreApiBean getPropertyStore() {
        PropertyStore propertyStore = this.getFf4j().getPropertiesStore();
        Intrinsics.checkNotNullExpressionValue((Object)propertyStore, (String)"ff4j.propertiesStore");
        return new PropertyStoreApiBean(propertyStore);
    }

    @NotNull
    public List<PropertyApiBean> getAllProperties() {
        List list;
        Map allProperties = this.getFf4j().getPropertiesStore().readAllProperties();
        if (CollectionUtils.isEmpty((Map)allProperties)) {
            list = new ArrayList(0);
        } else {
            List list2 = allProperties.values().stream().map(getAllProperties.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"allProperties.values.str\u2026lect(Collectors.toList())");
            list = list2;
        }
        return list;
    }

    public void deleteAllProperties() {
        this.getFf4j().getPropertiesStore().clear();
    }

    @NotNull
    public CacheApiBean getPropertiesFromCache() {
        if (this.getFf4j().getCacheProxy() == null) {
            throw (Throwable)new PropertyStoreNotCached();
        }
        PropertyStore propertyStore = this.getFf4j().getPropertiesStore();
        Intrinsics.checkNotNullExpressionValue((Object)propertyStore, (String)"ff4j.propertiesStore");
        return new CacheApiBean(propertyStore);
    }

    public void clearCachedPropertyStore() {
        FF4jCacheProxy fF4jCacheProxy = this.getFf4j().getCacheProxy();
        if (fF4jCacheProxy == null) {
            throw (Throwable)new PropertyStoreNotCached();
        }
        FF4jCacheProxy cacheProxy = fF4jCacheProxy;
        cacheProxy.getCacheManager().clearProperties();
    }

    @NotNull
    public FF4j getFf4j() {
        return this.ff4j;
    }

    public PropertyStoreServices(@Autowired @NotNull FF4j ff4j) {
        Intrinsics.checkNotNullParameter((Object)ff4j, (String)"ff4j");
        this.ff4j = ff4j;
    }
}

