/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.model.FeatureActions;
import org.ff4j.services.validator.FeatureValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/ff4j/services/FeatureServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "featureValidator", "Lorg/ff4j/services/validator/FeatureValidator;", "(Lorg/ff4j/FF4j;Lorg/ff4j/services/validator/FeatureValidator;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "getFeatureValidator", "()Lorg/ff4j/services/validator/FeatureValidator;", "addGroupToFeature", "", "featureUID", "", "groupName", "createOrUpdateFeature", "Lorg/ff4j/services/model/FeatureActions;", "featureApiBean", "Lorg/ff4j/services/domain/FeatureApiBean;", "deleteFeature", "disableFeature", "enableFeature", "getFeature", "grantRoleToFeature", "roleName", "removeGroupFromFeature", "removeRoleFromFeature", "ff4j-spring-services"})
public class FeatureServices {
    @NotNull
    private final FF4j fF4j;
    @NotNull
    private final FeatureValidator featureValidator;

    public FeatureServices(@Autowired @NotNull FF4j fF4j, @Autowired @NotNull FeatureValidator featureValidator) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"fF4j");
        Intrinsics.checkNotNullParameter((Object)featureValidator, (String)"featureValidator");
        this.fF4j = fF4j;
        this.featureValidator = featureValidator;
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public FeatureValidator getFeatureValidator() {
        return this.featureValidator;
    }

    @NotNull
    public FeatureApiBean getFeature(@NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        Feature feature = this.getFF4j().getFeatureStore().read(featureUID);
        Intrinsics.checkNotNullExpressionValue((Object)feature, (String)"fF4j.featureStore.read(featureUID)");
        return new FeatureApiBean(feature);
    }

    @NotNull
    public FeatureActions createOrUpdateFeature(@NotNull String featureUID, @NotNull FeatureApiBean featureApiBean) {
        FeatureActions featureActions;
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)featureApiBean, (String)"featureApiBean");
        this.getFeatureValidator().assertFeatureUIDIsNotBlank(featureApiBean.getUid());
        this.getFeatureValidator().assertFeatureIdsMatch(featureUID, featureApiBean.getUid());
        if (this.getFF4j().getFeatureStore().exist(featureUID)) {
            this.getFF4j().getFeatureStore().update(featureApiBean.toFeature());
            featureActions = FeatureActions.UPDATED;
        } else {
            this.getFF4j().getFeatureStore().create(featureApiBean.toFeature());
            featureActions = FeatureActions.CREATED;
        }
        return featureActions;
    }

    public void deleteFeature(@NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFF4j().getFeatureStore().delete(featureUID);
    }

    public void disableFeature(@NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFF4j().getFeatureStore().disable(featureUID);
    }

    public void enableFeature(@NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFF4j().getFeatureStore().enable(featureUID);
    }

    public void grantRoleToFeature(@NotNull String featureUID, @NotNull String roleName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFeatureValidator().assertRoleDoesNotExist(featureUID, roleName);
        this.getFF4j().getFeatureStore().grantRoleOnFeature(featureUID, roleName);
    }

    public void removeRoleFromFeature(@NotNull String featureUID, @NotNull String roleName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFeatureValidator().assertRoleExist(featureUID, roleName);
        this.getFF4j().getFeatureStore().removeRoleFromFeature(featureUID, roleName);
    }

    public void addGroupToFeature(@NotNull String featureUID, @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFeatureValidator().assertGroupDoesNotExist(groupName);
        this.getFF4j().getFeatureStore().addToGroup(featureUID, groupName);
    }

    public void removeGroupFromFeature(@NotNull String featureUID, @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFeatureValidator().assertFeatureExists(featureUID);
        this.getFeatureValidator().assertGroupExist(groupName);
        this.getFF4j().getFeatureStore().removeFromGroup(featureUID, groupName);
    }
}

