/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.property.Property;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.model.FeatureActions;
import org.ff4j.services.validator.PropertyValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/ff4j/services/PropertyServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "propertyValidator", "Lorg/ff4j/services/validator/PropertyValidator;", "(Lorg/ff4j/FF4j;Lorg/ff4j/services/validator/PropertyValidator;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "getPropertyValidator", "()Lorg/ff4j/services/validator/PropertyValidator;", "createOrUpdateProperty", "Lreactor/core/publisher/Mono;", "Lorg/ff4j/services/model/FeatureActions;", "propertyUID", "", "propertyApiBean", "Lorg/ff4j/services/domain/PropertyApiBean;", "deleteProperty", "", "getProperty", "updatePropertyName", "newPropertyName", "ff4j-spring-services"})
public class PropertyServices {
    @NotNull
    private final FF4j fF4j;
    @NotNull
    private final PropertyValidator propertyValidator;

    public PropertyServices(@Autowired @NotNull FF4j fF4j, @Autowired @NotNull PropertyValidator propertyValidator) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"fF4j");
        Intrinsics.checkNotNullParameter((Object)propertyValidator, (String)"propertyValidator");
        this.fF4j = fF4j;
        this.propertyValidator = propertyValidator;
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public PropertyValidator getPropertyValidator() {
        return this.propertyValidator;
    }

    @NotNull
    public Mono<PropertyApiBean> getProperty(@NotNull String propertyUID) {
        Intrinsics.checkNotNullParameter((Object)propertyUID, (String)"propertyUID");
        this.getPropertyValidator().assertPropertyExist(propertyUID);
        Property property = this.getFF4j().getPropertiesStore().readProperty(propertyUID);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"readProperty(...)");
        Mono mono = Mono.just((Object)new PropertyApiBean(property));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    @NotNull
    public Mono<FeatureActions> createOrUpdateProperty(@NotNull String propertyUID, @NotNull PropertyApiBean propertyApiBean) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)propertyUID, (String)"propertyUID");
        Intrinsics.checkNotNullParameter((Object)propertyApiBean, (String)"propertyApiBean");
        this.getPropertyValidator().assertPropertyNameNotBlank(propertyApiBean.getName());
        this.getPropertyValidator().assertPropertyNameMatch(propertyUID, propertyApiBean.getName());
        Property<?> property = propertyApiBean.asProperty();
        if (this.getFF4j().getPropertiesStore().existProperty(propertyUID)) {
            this.getFF4j().getPropertiesStore().updateProperty(property);
            Mono mono2 = Mono.just((Object)((Object)FeatureActions.UPDATED));
            Intrinsics.checkNotNull((Object)mono2);
            mono = mono2;
        } else {
            this.getFF4j().getPropertiesStore().createProperty(property);
            Mono mono3 = Mono.just((Object)((Object)FeatureActions.CREATED));
            Intrinsics.checkNotNull((Object)mono3);
            mono = mono3;
        }
        return mono;
    }

    public void deleteProperty(@NotNull String propertyUID) {
        Intrinsics.checkNotNullParameter((Object)propertyUID, (String)"propertyUID");
        this.getPropertyValidator().assertPropertyExist(propertyUID);
        this.getFF4j().getPropertiesStore().deleteProperty(propertyUID);
    }

    public void updatePropertyName(@NotNull String propertyUID, @NotNull String newPropertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyUID, (String)"propertyUID");
        Intrinsics.checkNotNullParameter((Object)newPropertyName, (String)"newPropertyName");
        this.getPropertyValidator().assertPropertyExist(propertyUID);
        this.getFF4j().getPropertiesStore().updateProperty(propertyUID, newPropertyName);
    }
}

